/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.jas3;

import java.awt.Dimension;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.freehep.jas.services.PreferencesTopic;
import org.lsst.ccs.gconsole.base.Console;

public class PreferencePage
implements PreferencesTopic {
    private final Console console;
    private final String[] path;
    private final ArrayList<Setter> setters = new ArrayList(1);

    public PreferencePage(Console console, String[] path) {
        this.console = console;
        this.path = path;
    }

    public synchronized void add(String group, String format) {
        this.setters.add(new Setter(group, format));
        this.setters.trimToSize();
    }

    public String[] path() {
        return this.path;
    }

    public synchronized JComponent component() {
        try {
            return new GUI();
        }
        catch (IllegalArgumentException x) {
            return new JLabel("  " + x.getMessage() + "  ");
        }
    }

    public boolean apply(JComponent panel) {
        try {
            return ((GUI)panel).apply();
        }
        catch (ClassCastException x) {
            return true;
        }
    }

    private Widget createWidget(String key, String qualifier) {
        Object value = this.console.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("No such property: " + key);
        }
        Class<?> c = value.getClass();
        HashMap<String, String> tokens = new HashMap<String, String>();
        if (qualifier != null && !qualifier.isEmpty()) {
            String[] ss;
            for (String s : ss = qualifier.split("\\#")) {
                int i = s.indexOf("=");
                if (i == -1) {
                    tokens.put(s, null);
                    continue;
                }
                tokens.put(s.substring(0, i), s.substring(i + 1));
            }
        }
        if (Boolean.class.isAssignableFrom(c)) {
            return new BooleanWidget(value);
        }
        if (Integer.class.isAssignableFrom(c)) {
            return new IntegerWidget(value);
        }
        if (Long.class.isAssignableFrom(c)) {
            return new LongWidget(value);
        }
        if (Double.class.isAssignableFrom(c)) {
            return new DoubleWidget(value);
        }
        if (String.class.isAssignableFrom(c)) {
            try {
                int n = Integer.parseInt((String)tokens.get("history"));
                return new StringWithHistoryWidget(key, (String)value, n);
            }
            catch (ClassCastException | IllegalArgumentException | NullPointerException x) {
                return new StringWidget(value);
            }
        }
        if (Enum.class.isAssignableFrom(c)) {
            return new EnumWidget(value);
        }
        throw new IllegalArgumentException("Unsupported preference type: " + c.getName());
    }

    public static void main(String ... args) {
        Pattern p = Pattern.compile("\\$\\{[^{}]+\\}");
        Matcher m = p.matcher("pre1${par1}pre2${par2}post");
        while (m.find()) {
            System.out.println("start " + m.start() + " end " + m.end() + " group " + m.group() + " count " + m.groupCount());
        }
        System.out.println(m.appendTail(new StringBuffer()));
    }

    private class Setter {
        String group;
        String format;

        Setter(String group, String format) {
            this.group = group;
            this.format = format;
        }
    }

    private class GUI
    extends Box {
        private final int HSPACE = 10;
        private final int VSPACE = 5;
        private final Pattern ptrn;
        private final HashMap<String, Widget> data;

        GUI() {
            super(1);
            this.HSPACE = 10;
            this.VSPACE = 5;
            this.ptrn = Pattern.compile("\\$\\{[^}]+\\}");
            this.data = new HashMap();
            this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            HashMap<String, Box> groups = new HashMap<String, Box>();
            for (Setter setter : PreferencePage.this.setters) {
                String s;
                Box line = Box.createHorizontalBox();
                if (setter.group == null) {
                    this.add(line);
                    this.add(Box.createRigidArea(new Dimension(0, 5)));
                } else {
                    Box groupBox = (Box)groups.get(setter.group);
                    if (groupBox == null) {
                        groupBox = Box.createVerticalBox();
                        groupBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(setter.group), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
                        groups.put(setter.group, groupBox);
                        this.add(Box.createRigidArea(new Dimension(0, 5)));
                        this.add(groupBox);
                        this.add(Box.createRigidArea(new Dimension(0, 5)));
                    }
                    groupBox.add(line);
                    groupBox.add(Box.createRigidArea(new Dimension(0, 5)));
                }
                Matcher mat = this.ptrn.matcher(setter.format);
                int i = 0;
                while (mat.find()) {
                    s = setter.format.substring(i, mat.start());
                    if (!s.isEmpty()) {
                        line.add(new JLabel(s));
                        line.add(Box.createRigidArea(new Dimension(10, 0)));
                    }
                    i = mat.end();
                    String qualifier = null;
                    String key = setter.format.substring(mat.start() + 2, mat.end() - 1);
                    int k = key.indexOf("#");
                    if (k != -1) {
                        qualifier = key.substring(k + 1);
                        key = key.substring(0, k);
                    }
                    Widget pd = PreferencePage.this.createWidget(key, qualifier);
                    line.add(pd.getComponent());
                    line.add(Box.createRigidArea(new Dimension(10, 0)));
                    Widget old = this.data.put(key, pd);
                    if (old == null) continue;
                    throw new IllegalArgumentException("Multiple setters for property: " + key);
                }
                s = setter.format.substring(i, setter.format.length());
                if (!s.isEmpty()) {
                    line.add(new JLabel(s));
                    line.add(Box.createRigidArea(new Dimension(10, 0)));
                }
                line.add(Box.createHorizontalGlue());
            }
            this.add(Box.createVerticalGlue());
        }

        boolean apply() {
            try {
                Map<String, Object> newValues = this.data.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((Widget)e.getValue()).getValue()));
                this.data.values().forEach(widget -> widget.save());
                PreferencePage.this.console.setProperties(newValues);
                return true;
            }
            catch (IllegalArgumentException x) {
                return false;
            }
        }
    }

    private class BooleanWidget
    extends Widget {
        final JCheckBox checkBox = new JCheckBox();

        BooleanWidget(Object value) {
            this.checkBox.setSelected((Boolean)value);
        }

        @Override
        Object getValue() {
            return this.checkBox.isSelected();
        }

        @Override
        JComponent getComponent() {
            return this.checkBox;
        }
    }

    private static class IntegerWidget
    extends Widget {
        final JTextField textField;

        IntegerWidget(Object value) {
            this.textField = new JTextField(value.toString(), 11);
            this.textField.setMaximumSize(this.textField.getPreferredSize());
        }

        @Override
        Object getValue() {
            return Integer.valueOf(this.textField.getText());
        }

        @Override
        JComponent getComponent() {
            return this.textField;
        }
    }

    private class LongWidget
    extends Widget {
        final JTextField textField;

        LongWidget(Object value) {
            this.textField = new JTextField(value.toString(), 20);
            this.textField.setMaximumSize(this.textField.getPreferredSize());
        }

        @Override
        Object getValue() {
            return Long.valueOf(this.textField.getText());
        }

        @Override
        JComponent getComponent() {
            return this.textField;
        }
    }

    private class DoubleWidget
    extends Widget {
        final JTextField textField;

        DoubleWidget(Object value) {
            this.textField = new JTextField(value.toString(), 12);
            this.textField.setMaximumSize(this.textField.getPreferredSize());
        }

        @Override
        Object getValue() {
            return Double.valueOf(this.textField.getText());
        }

        @Override
        JComponent getComponent() {
            return this.textField;
        }
    }

    private class StringWithHistoryWidget
    extends Widget {
        final String historyKey;
        final int keep;
        final JComboBox combo;
        final ArrayDeque history;

        StringWithHistoryWidget(String key, String value, int keep) {
            this.historyKey = key + "$history$";
            this.keep = keep;
            PreferencePage.this.console.addProperty(this.historyKey, new String[0]);
            String[] hh = (String[])PreferencePage.this.console.getProperty(this.historyKey);
            if (hh == null) {
                hh = new String[]{};
            }
            this.history = new ArrayDeque(hh.length + 2);
            for (String h : hh) {
                if (value.equals(h)) continue;
                this.history.add(h);
            }
            this.history.addFirst(value);
            this.combo = new JComboBox<String>(this.history.toArray(new String[0]));
            this.combo.setMaximumSize(this.combo.getPreferredSize());
            this.combo.setEditable(true);
        }

        @Override
        String getValue() {
            return (String)this.combo.getSelectedItem();
        }

        @Override
        JComponent getComponent() {
            return this.combo;
        }

        @Override
        void save() {
            String value = this.getValue();
            if (!this.history.contains(value)) {
                this.history.addFirst(value);
            }
            while (this.history.size() > this.keep) {
                this.history.removeLast();
            }
            PreferencePage.this.console.setProperty(this.historyKey, this.history.toArray(new String[0]));
        }
    }

    private class StringWidget
    extends Widget {
        final JTextField textField;

        StringWidget(Object value) {
            this.textField = new JTextField(value.toString());
            this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.textField.getPreferredSize().height));
        }

        @Override
        String getValue() {
            return this.textField.getText();
        }

        @Override
        JComponent getComponent() {
            return this.textField;
        }
    }

    private class EnumWidget
    extends Widget {
        final JComboBox combo;

        EnumWidget(Object value) {
            Enum enumValue = (Enum)value;
            enumValue.getDeclaringClass().getEnumConstants();
            this.combo = new JComboBox(enumValue.getDeclaringClass().getEnumConstants());
            this.combo.setSelectedItem(enumValue);
            this.combo.setMaximumSize(this.combo.getPreferredSize());
        }

        @Override
        Object getValue() {
            return this.combo.getSelectedItem();
        }

        @Override
        JComponent getComponent() {
            return this.combo;
        }
    }

    static abstract class Widget {
        Widget() {
        }

        abstract Object getValue();

        abstract JComponent getComponent();

        void save() {
        }
    }
}

