/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public abstract class AbstractComboBoxBrowser
implements Serializable {
    private final Listener listener = new Listener();
    private JComboBox comboBox;
    private transient boolean recursion;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractComboBoxBrowser() {
    }

    public AbstractComboBoxBrowser(JComboBox comboBox) {
        this.changeComboBox(null, comboBox, false);
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(JComboBox comboBox) {
        this.changeComboBox(this.getComboBox(), comboBox, true);
    }

    private void changeComboBox(JComboBox oldCB, JComboBox newCB, boolean update) {
        if (newCB == oldCB) {
            return;
        }
        ComboBoxEditor oldCBE = null;
        if (oldCB != null) {
            oldCB.removePropertyChangeListener("editor", this.listener);
            oldCBE = oldCB.getEditor();
            oldCB.setEditor(((ComboBoxEditorProxy)oldCBE).getEditor());
        }
        this.comboBox = newCB;
        ComboBoxEditorProxy newCBE = null;
        if (newCB != null) {
            newCB.updateUI();
            newCBE = new ComboBoxEditorProxy(newCB.getEditor());
            newCB.setEditor(newCBE);
            newCB.addPropertyChangeListener("editor", this.listener);
        }
        this.changeEditor(oldCBE, newCBE, update);
    }

    private void changeEditor(ComboBoxEditor oldCBE, ComboBoxEditor newCBE, boolean update) {
        Component component;
        Component component2;
        if (newCBE == oldCBE) {
            return;
        }
        JTextComponent oldText = null;
        if (oldCBE != null && (component2 = oldCBE.getEditorComponent()) instanceof JTextComponent) {
            oldText = (JTextComponent)component2;
        }
        JTextComponent newText = null;
        if (newCBE != null && (component = newCBE.getEditorComponent()) instanceof JTextComponent) {
            newText = (JTextComponent)component;
        }
        this.changeText(oldText, newText, update);
    }

    private void changeText(JTextComponent oldTC, JTextComponent newTC, boolean update) {
        if (newTC == oldTC) {
            return;
        }
        Document oldDocument = null;
        if (oldTC != null) {
            oldTC.removePropertyChangeListener("document", this.listener);
            oldDocument = oldTC.getDocument();
        }
        Document newDocument = null;
        if (newTC != null) {
            newDocument = newTC.getDocument();
            newTC.addPropertyChangeListener("document", this.listener);
        }
        this.changeDocument(oldDocument, newDocument, update);
    }

    private void changeDocument(Document oldDoc, Document newDoc, boolean update) {
        if (newDoc == oldDoc) {
            return;
        }
        if (oldDoc != null) {
            oldDoc.removeDocumentListener(this.listener);
        }
        if (newDoc != null) {
            if (update) {
                String txt;
                try {
                    txt = newDoc.getText(0, newDoc.getLength());
                }
                catch (BadLocationException e) {
                    txt = null;
                }
                this.update(txt);
            }
            newDoc.addDocumentListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentUpdated() {
        if (this.lock()) {
            return;
        }
        try {
            JComboBox cb = this.getComboBox();
            ComboBoxEditor cbe = cb.getEditor();
            JTextComponent tc = (JTextComponent)cbe.getEditorComponent();
            if (!$assertionsDisabled && !cb.isShowing() && tc.isFocusOwner()) {
                throw new AssertionError();
            }
            if (!tc.isFocusOwner()) {
                return;
            }
            cb.setPopupVisible(false);
            if (this.update(tc.getText())) {
                cb.setPopupVisible(true);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEditor(ComboBoxEditor cbe, Object item) {
        if (this.lock()) {
            return;
        }
        try {
            cbe.setItem(item);
            if (!(item instanceof String)) {
                return;
            }
            JComboBox cb = this.getComboBox();
            JTextComponent tc = (JTextComponent)cbe.getEditorComponent();
            if (!$assertionsDisabled && !cb.isShowing() && tc.isFocusOwner()) {
                throw new AssertionError();
            }
            if (!tc.isFocusOwner()) {
                return;
            }
            Caret caret = tc.getCaret();
            caret.setDot(((String)item).length());
        }
        finally {
            this.unlock();
        }
    }

    protected abstract boolean update(String var1);

    private final boolean lock() {
        if (this.recursion) {
            return true;
        }
        this.recursion = true;
        return false;
    }

    private final void unlock() {
        this.recursion = false;
    }

    static {
        $assertionsDisabled = !AbstractComboBoxBrowser.class.desiredAssertionStatus();
    }

    private final class ComboBoxEditorProxy
    extends BasicComboBoxEditor {
        private final ComboBoxEditor comboBoxEditor;

        public ComboBoxEditorProxy(ComboBoxEditor comboBoxEditor) {
            this.comboBoxEditor = comboBoxEditor;
        }

        public ComboBoxEditor getEditor() {
            return this.comboBoxEditor;
        }

        public Component getEditorComponent() {
            return this.comboBoxEditor.getEditorComponent();
        }

        public void setItem(Object item) {
            AbstractComboBoxBrowser.this.updateEditor(this.comboBoxEditor, item);
        }

        public Object getItem() {
            return this.comboBoxEditor.getItem();
        }

        public void selectAll() {
            this.comboBoxEditor.selectAll();
        }

        public void addActionListener(ActionListener actionListener) {
            this.comboBoxEditor.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.comboBoxEditor.removeActionListener(actionListener);
        }
    }

    private final class Listener
    implements DocumentListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void insertUpdate(DocumentEvent e) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        public void removeUpdate(DocumentEvent e) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        public void changedUpdate(DocumentEvent e) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        public void propertyChange(PropertyChangeEvent e) {
            String property = e.getPropertyName();
            if ("editor".equals(property)) {
                AbstractComboBoxBrowser.this.changeEditor((ComboBoxEditor)e.getOldValue(), (ComboBoxEditor)e.getNewValue(), true);
            } else if ("document".equals(property)) {
                AbstractComboBoxBrowser.this.changeDocument((Document)e.getOldValue(), (Document)e.getNewValue(), true);
            } else {
                throw new AssertionError((Object)("Received change event for unknown property: " + property));
            }
        }
    }
}

