<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:fn="http://www.w3.org/2005/xpath-functions"
                xmlns:functx="http://www.functx.com" 
                xmlns:xs="http://www.w3.org/2001/XMLSchema">
    <xsl:output encoding="UTF-8" method="text"/>

    <xsl:function name="functx:chars" as="xs:string*"
                  xmlns:functx="http://www.functx.com">
        <xsl:param name="arg" as="xs:string?"/>
    
        <xsl:sequence select="
			  for $ch in string-to-codepoints($arg)
			  return codepoints-to-string($ch)
			  "/>
    
    </xsl:function>


    <xsl:function name="functx:pad-string-to-length" as="xs:string"
                  xmlns:functx="http://www.functx.com">
        <xsl:param name="stringToPad" as="xs:string?"/>
        <xsl:param name="padChar" as="xs:string"/>
        <xsl:param name="length" as="xs:integer"/>
    
        <xsl:sequence select="
			  substring(
			  string-join (
			  ($stringToPad, for $i in (1 to $length) return $padChar)
			  ,'')
			  ,1,$length)
			  "/>
    
    </xsl:function>
  
  
    <xsl:template match="/sequencer">
        <xsl:apply-templates select="sequencer-config"/>
        <xsl:apply-templates select="sequencer-routines"/>
    </xsl:template>

    <xsl:template match="sequencer-config">
        <xsl:apply-templates select="parameters"/>
        <xsl:apply-templates select="channels"/>

        <xsl:text>&#xA;[pointers]&#xA;</xsl:text>
        <xsl:apply-templates select="funcptrs"/>
        <xsl:apply-templates select="funcrepptrs"/>
        <xsl:apply-templates select="subptrs"/>
        <xsl:apply-templates select="subrepptrs"/>

        <xsl:apply-templates select="functions"/>
    </xsl:template>

    <xsl:template match="sequencer-routines">
        <xsl:apply-templates select="subroutines"/>
        <xsl:apply-templates select="mains"/>
    </xsl:template>


    <xsl:template match="parameters">
        <xsl:text>[constants]&#xA;</xsl:text>
        <xsl:apply-templates select="parameter"/>
    </xsl:template>

    <xsl:template match="parameter">
        <xsl:text>    </xsl:text>
        <xsl:value-of select="@id"/>: <xsl:value-of select="value"/> # <xsl:value-of select="fullname"/>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>


    <xsl:template match="channels">
        <xsl:text>&#xA;[clocks]&#xA;</xsl:text>
        <xsl:apply-templates select="channel"/>
    </xsl:template>


    <xsl:template match="channel">
        <xsl:text>    </xsl:text>
        <xsl:value-of select="@id"/>: <xsl:value-of select="value"/> # <xsl:value-of select="fullname"/>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>

    <xsl:template match="funcptrs">
        <xsl:apply-templates select="funcptr"/>
    </xsl:template>

    <xsl:template match="funcrepptrs">
        <xsl:apply-templates select="funcrepptr"/>
    </xsl:template>

    <xsl:template match="subptrs">
        <xsl:apply-templates select="subptr"/>
    </xsl:template>

    <xsl:template match="subrepptrs">
        <xsl:apply-templates select="subrepptr"/>
    </xsl:template>

    <xsl:template match="funcptr">
        <xsl:text>    PTR_FUNC    </xsl:text>
        <xsl:value-of select="@id"/> 
        <xsl:text>   </xsl:text>
        <xsl:value-of select="@fcn"/>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>

    <xsl:template match="funcrepptr">
        <xsl:text>    REP_FUNC    </xsl:text>
        <xsl:value-of select="@id"/> 
        <xsl:text>   </xsl:text>
        <xsl:value-of select="@n"/>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>
  
    <xsl:template match="subptr">
        <xsl:text>    PTR_SUBR  </xsl:text>
        <xsl:value-of select="@id"/>
        <xsl:text>   </xsl:text>
        <xsl:value-of select="@sub"/>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>
  
    <xsl:template match="subrepptr">
        <xsl:text>    REP_SUBR    </xsl:text>
        <xsl:value-of select="@id"/>
        <xsl:text>   </xsl:text>
        <xsl:value-of select="@n"/>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>

  
    <xsl:template match="functions">
        <xsl:text>&#xA;[functions]&#xA;</xsl:text>
        <xsl:apply-templates select="function"/>    
    </xsl:template>


    <xsl:template match="function">
        <xsl:text>    </xsl:text>
        <xsl:value-of select="@id"/>
        <xsl:text>: # </xsl:text>
        <xsl:value-of select="fullname"/>
        <xsl:text>&#xA;</xsl:text>
        <xsl:text>      clocks:          </xsl:text>
        <xsl:value-of select="clocklist/clock/@ref" separator=", "/>
        <xsl:text>&#xA;</xsl:text>
        <xsl:text>      slices:     </xsl:text>
        <xsl:text>&#xA;</xsl:text>
        <xsl:for-each select="slicelist/timeslice">
            <xsl:text>         </xsl:text>
            <xsl:value-of select="functx:pad-string-to-length(duration,' ',10)"/> 
            <xsl:text>  = </xsl:text>
            <xsl:value-of select="functx:chars(value)" separator=",  "/>
            <xsl:text>&#xA;</xsl:text>      
        </xsl:for-each>
        <xsl:if test="constants">
            <xsl:text>      constants:     </xsl:text>
            <xsl:value-of select="for $ch in constants/constant return fn:concat($ch/@ref,'=',normalize-space($ch))" separator=", "/>
            <xsl:text>&#xA;</xsl:text>
        </xsl:if>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>

    <xsl:template match="subroutines">
        <xsl:text>[subroutines]</xsl:text>
        <xsl:text>&#xA;</xsl:text>
        <xsl:apply-templates select="subroutine"/>

        <xsl:apply-templates select="//call" mode="anon"/>
    </xsl:template>

    <xsl:template match="mains">
        <xsl:text>[mains]</xsl:text>
        <xsl:text>&#xA;</xsl:text>
        <xsl:apply-templates select="main"/>
    </xsl:template>

    <xsl:template match="subroutine|main">
        <xsl:text>      </xsl:text>
        <xsl:value-of select="@id"/>
        <xsl:text>: #</xsl:text>
        <xsl:value-of select="fullname"/>
        <xsl:text>&#xA;</xsl:text>
        <xsl:apply-templates select="call"/>
        <xsl:text>        RTS</xsl:text>
        <xsl:text>&#xA;</xsl:text>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>

    <xsl:template match="call[@fcn or @fcnptr]">
        <xsl:text>        CALL    </xsl:text>
        <xsl:if test="@fcn">
            <xsl:value-of select="functx:pad-string-to-length(@fcn,' ',20)"/> 
        </xsl:if>
        <xsl:if test="@fcnptr">
            <xsl:text>@</xsl:text>
            <xsl:value-of select="functx:pad-string-to-length(@fcnptr,' ',19)"/>
        </xsl:if>
        <xsl:if test="repeat">
            <xsl:text>     repeat(</xsl:text>
            <xsl:value-of select="repeat"/>
            <xsl:text>)</xsl:text>
        </xsl:if>
        <xsl:if test="repeatfcnptr">
            <xsl:text>     repeat(@</xsl:text>
            <xsl:value-of select="repeatfcnptr"/>
            <xsl:text>)</xsl:text>
        </xsl:if>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>
  
    <xsl:template match="call[@sub or @subptr]">
        <xsl:text>        JSR     </xsl:text>
        <xsl:if test="@sub">  
            <xsl:value-of select="functx:pad-string-to-length(@sub,' ',20)"/>
        </xsl:if>
        <xsl:if test="@subptr">
            <xsl:text>@</xsl:text>
            <xsl:value-of select="functx:pad-string-to-length(@subptr,' ',19)"/>
        </xsl:if>
        <xsl:if test="repeat">
            <xsl:text>     repeat(</xsl:text>
            <xsl:value-of select="repeat"/>
            <xsl:text>)</xsl:text>
        </xsl:if>
        <xsl:if test="repeatsubptr">
            <xsl:text>     repeat(@</xsl:text>
            <xsl:value-of select="repeatsubptr"/>
            <xsl:text>)</xsl:text>
        </xsl:if>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>
  
    <xsl:template match="call[not(@*)]">
        <xsl:text>        JSR     Anon_</xsl:text>
        <xsl:value-of select="functx:pad-string-to-length(fn:string(position()),' ',15)"/>
        <xsl:if test="repeat">
            <xsl:text>     repeat(</xsl:text>
            <xsl:value-of select="repeat"/>
            <xsl:text>)</xsl:text>
        </xsl:if>
        <xsl:if test="repeatsubptr">
            <xsl:text>     repeat(@</xsl:text>
            <xsl:value-of select="repeatsubptr"/>
            <xsl:text>)</xsl:text>
        </xsl:if>
        <xsl:text>&#xA;</xsl:text>
    </xsl:template>


    <xsl:template match="call[not(@*)]" mode="anon">
        <xsl:text>      Anon_</xsl:text>
        <xsl:value-of select="position()"/>
        <xsl:text>:&#xA;</xsl:text>
        <xsl:apply-templates select="call"/>
        <xsl:text>        RTS</xsl:text>
        <xsl:text>&#xA;</xsl:text>

    </xsl:template>

    <xsl:template match="call[@*]" mode="anon">
    </xsl:template>
  

</xsl:stylesheet>
  

