/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.Transient;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.LsstMonitorPlugin;
import org.lsst.ccs.gconsole.plugins.monitor.MeshTable;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorDisplay;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTable;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTable;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.persist.Persistable;

public class LazyTreeView
extends AbstractMonitorView {
    public static final String CREATOR_PATH = "Built-In/Basic/Tree";
    public static final String CREATOR_PATH_CONF = "Built-In/Basic/Tree, Configurable";
    private Descriptor descriptor = new Descriptor();
    private final RootNode root = new RootNode();
    DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
    private final Tree tree = new Tree(this.treeModel);
    private final JScrollPane scrollPane;
    private boolean doScroll = true;

    @Create(category="MonitorView", name="Lazy Tree View", path="Built-In/Basic/Tree", description="Monitoring data view that displays its data in a tree of tables.")
    public LazyTreeView() {
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                InterNode node = (InterNode)event.getPath().getLastPathComponent();
                node.getDescriptor().setExpanded(true);
                if (node.isLazy()) {
                    node.rebuild();
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                InterNode node = (InterNode)event.getPath().getLastPathComponent();
                node.getDescriptor().setExpanded(false);
            }
        });
        this.scrollPane = new JScrollPane(this.tree);
        this.root.build(Collections.emptyList());
    }

    @Create(category="MonitorView", name="Lazy Tree View", path="Built-In/Basic/Tree, Configurable", description="Monitoring data view that displays its data in a tree of tables.")
    public LazyTreeView(@Par(def="_null_", desc="List of fields to display. If not specified, the set of fields provided by the filter is used. Available standard fields: VALUE, UNITS, LOW_WARN, LOW_ALARM, ALERT_LOW, HIGH_WARN, HIGH_ALARM, ALERT_HIGH, DESCR") List<String> fields) {
        this();
        if (fields != null) {
            this.descriptor.setFields(fields.toArray(new String[0]));
        }
    }

    @Override
    protected void resetChannels() {
        this.root.setLoading(true);
        this.updateDescriptor(this.root);
        this.root.clear();
        this.root.build(this.data.entrySet());
        this.root.setLoading(false);
        this.treeModel.reload();
        this.root.restoreExpansion();
    }

    @Override
    public JComponent getPanel() {
        return this.scrollPane;
    }

    @Override
    public Descriptor save() {
        this.getDescriptor().setNodes(null);
        this.updateDescriptor(this.root);
        return this.descriptor.clone();
    }

    @Override
    public void restore(Persistable.Descriptor descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = ((Descriptor)descriptor).clone();
            this.root.clear();
            this.root.build(this.data.entrySet());
            this.treeModel.nodeStructureChanged(this.root);
            this.root.restoreExpansion();
        }
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    private void updateDescriptor(Node node) {
        TreeMap<String, Serializable> nodes = this.getDescriptor().getNodes();
        if (nodes == null) {
            nodes = new TreeMap();
            this.getDescriptor().setNodes(nodes);
        }
        Object path = node.getPathString();
        Serializable desc = node.save();
        if (desc == null) {
            nodes.remove(path);
        } else {
            nodes.put((String)path, desc);
        }
        if (node != this.root) {
            path = (String)path + "/";
        }
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            this.updateDescriptor((Node)en.nextElement(), (String)path, nodes);
        }
    }

    private void updateDescriptor(Node node, String path, TreeMap<String, Serializable> map) {
        Serializable desc = node.save();
        path = (String)path + node.toString();
        if (desc == null) {
            map.remove(path);
        } else {
            map.put((String)path, desc);
        }
        path = (String)path + "/";
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            this.updateDescriptor((Node)en.nextElement(), (String)path, map);
        }
    }

    public static class Descriptor
    extends AbstractMonitorView.Descriptor {
        private TreeMap<String, Serializable> nodes;

        public TreeMap<String, Serializable> getNodes() {
            return this.nodes;
        }

        public void setNodes(TreeMap<String, Serializable> nodes) {
            this.nodes = nodes;
        }

        @Override
        public Descriptor clone() {
            Descriptor desc = (Descriptor)super.clone();
            if (desc.nodes != null) {
                desc.nodes = new TreeMap<String, Serializable>((SortedMap<String, Serializable>)desc.nodes);
            }
            return desc;
        }
    }

    private final class RootNode
    extends InterNode {
        RootNode() {
            super("");
            this.setLoading(false);
        }

        @Override
        InterNodeDescriptor save() {
            return this.desc.getFlags() == 32 ? null : this.desc.clone();
        }

        void setLoading(boolean loading) {
            super.setUserObject(loading ? "Loaging..." : "Camera Control System");
            if (LazyTreeView.this.treeModel != null) {
                LazyTreeView.this.treeModel.nodeChanged(this);
            }
        }

        @Override
        void restoreExpansion() {
            if (!this.desc.isExpanded()) {
                LazyTreeView.this.tree.collapsePath(new TreePath(this.getPath()));
            }
            super.restoreExpansion();
        }
    }

    final class Tree
    extends JTree
    implements MonitorDisplay {
        Tree(TreeModel model) {
            super(model);
            this.setRootVisible(true);
            this.setShowsRootHandles(true);
            this.setRowHeight(0);
            this.setCellRenderer(new TreeRenderer());
            this.setCellEditor(new TreeEditor());
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (LazyTreeView.this.tree.getRowForLocation(e.getX(), e.getY()) != -1) {
                        LazyTreeView.this.tree.startEditingAtPath(LazyTreeView.this.tree.getPathForLocation(e.getX(), e.getY()));
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
            this.setEditable(true);
            this.getSelectionModel().setSelectionMode(1);
            this.setScrollsOnExpand(false);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            int limit;
            int out = super.getScrollableUnitIncrement(visibleRect, orientation, direction);
            if (orientation == 1 && out > (limit = visibleRect.height / 8)) {
                return limit;
            }
            return out;
        }

        @Override
        public void saveData(OutputStream out, String mimeType) {
            List<AgentChannel> channels = LazyTreeView.this.data.values().stream().map(handle -> handle.getChannel()).filter(channel -> channel != null).collect(Collectors.toList());
            LsstMonitorPlugin.saveData(out, mimeType, channels, LazyTreeView.this.fields);
        }

        @Override
        public void scrollPathToVisible(TreePath path) {
            if (LazyTreeView.this.doScroll) {
                super.scrollPathToVisible(path);
            }
        }

        @Override
        public void startEditingAtPath(TreePath path) {
            LazyTreeView.this.doScroll = false;
            super.startEditingAtPath(path);
            LazyTreeView.this.doScroll = true;
        }
    }

    private class Node
    extends DefaultMutableTreeNode {
        Node(String name) {
            super(name);
        }

        void clear() {
            Enumeration<TreeNode> en = this.children();
            while (en.hasMoreElements()) {
                ((Node)en.nextElement()).clear();
            }
            this.removeAllChildren();
        }

        Serializable save() {
            return null;
        }

        protected String getPathString() {
            StringJoiner sj = new StringJoiner("/");
            for (TreeNode node : this.getPath()) {
                if (node == LazyTreeView.this.root) continue;
                sj.add(node.toString());
            }
            return sj.toString();
        }
    }

    protected class MonitorTableNode
    extends DisplayNode {
        private final MonitorTable model;
        private final JPanel panel;

        MonitorTableNode(MonitorTable tableModel) {
            this(tableModel, tableModel.getClass().getName());
        }

        MonitorTableNode(MonitorTable tableModel, String name) {
            super(name);
            this.model = tableModel;
            if (LazyTreeView.this.formatter != null) {
                this.model.setFormat(LazyTreeView.this.formatter);
            }
            JTable table = this.model.getTable();
            this.panel = new JPanel(new BorderLayout());
            this.panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0), BorderFactory.createLineBorder(Color.BLACK)));
            if (this.model.showHeader()) {
                this.panel.add((Component)table.getTableHeader(), "North");
            }
            this.panel.add((Component)table, "Center");
        }

        @Override
        JComponent getComponent() {
            return this.panel;
        }

        @Override
        void clear() {
            this.model.destroy();
            super.clear();
        }

        @Override
        Serializable save() {
            return this.model.save();
        }
    }

    protected abstract class DisplayNode
    extends Node
    implements MonitorTable.Listener {
        DisplayNode() {
            super("display");
        }

        DisplayNode(String name) {
            super(name);
        }

        abstract JComponent getComponent();

        @Override
        public void stateChanged(MonitorTable.Event e) {
            if (this.parent == null) {
                return;
            }
            switch (e.getReason()) {
                case CELLS: {
                    LazyTreeView.this.treeModel.nodeChanged(this);
                    break;
                }
                case TABLE: {
                    InterNode p = (InterNode)this.parent;
                    p.rebuild();
                    LazyTreeView.this.tree.startEditingAtPath(new TreePath(p.getPath()));
                }
            }
        }
    }

    public static final class InterNodeDescriptor
    implements Serializable,
    Cloneable {
        static final int FLAT = 1;
        static final int MESH = 2;
        static final int FLIP = 4;
        static final int COMPACT = 8;
        static final int SECTION = 16;
        static final int EXPANDED = 32;
        static final int SORT = 64;
        private int flags;

        public int getFlags() {
            return this.flags;
        }

        @Transient
        public DisplayMode getDisplayMode() {
            if (this.isFlat()) {
                return DisplayMode.FLAT;
            }
            if (this.isMesh()) {
                return this.isFlip() ? DisplayMode.FLIPPED_MESH : DisplayMode.MESH;
            }
            return DisplayMode.TREE;
        }

        @Transient
        public boolean isFlat() {
            return (this.flags & 1) > 0;
        }

        @Transient
        public boolean isMesh() {
            return (this.flags & 2) > 0;
        }

        @Transient
        public boolean isFlip() {
            return (this.flags & 4) > 0;
        }

        @Transient
        public boolean isCompact() {
            return (this.flags & 8) > 0;
        }

        @Transient
        public boolean isSection() {
            return (this.flags & 0x10) > 0;
        }

        @Transient
        public boolean isExpanded() {
            return (this.flags & 0x20) > 0;
        }

        @Transient
        public Sort getSort() {
            return (this.flags & 0x40) > 0 ? Sort.ALPHABETIC : Sort.NONE;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }

        @Transient
        public void setDisplayMode(DisplayMode value) {
            switch (value) {
                case TREE: {
                    this.setFlat(false);
                    this.setMesh(false);
                    this.setFlip(false);
                    break;
                }
                case FLAT: {
                    this.setFlat(true);
                    this.setMesh(false);
                    this.setFlip(false);
                    break;
                }
                case MESH: {
                    this.setFlat(false);
                    this.setMesh(true);
                    this.setFlip(false);
                    break;
                }
                case FLIPPED_MESH: {
                    this.setFlat(false);
                    this.setMesh(true);
                    this.setFlip(true);
                }
            }
        }

        @Transient
        public void setFlat(boolean value) {
            this.setBits(value, 1);
        }

        @Transient
        public void setMesh(boolean value) {
            this.setBits(value, 2);
        }

        @Transient
        public void setFlip(boolean value) {
            this.setBits(value, 4);
        }

        @Transient
        public void setCompact(boolean value) {
            this.setBits(value, 8);
        }

        @Transient
        public void setSection(boolean value) {
            this.setBits(value, 16);
        }

        @Transient
        public void setExpanded(boolean value) {
            this.setBits(value, 32);
        }

        @Transient
        public void setSort(Sort value) {
            this.setBits(Sort.ALPHABETIC.equals(value), 64);
        }

        private void setBits(boolean value, int mask) {
            this.flags = value ? (this.flags |= mask) : (this.flags &= ~mask);
        }

        protected InterNodeDescriptor clone() {
            try {
                return (InterNodeDescriptor)super.clone();
            }
            catch (CloneNotSupportedException x) {
                return null;
            }
        }

        public static enum DisplayMode {
            TREE,
            FLAT,
            MESH,
            FLIPPED_MESH;

        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum Sort implements Comparator<Map.Entry<String, DisplayChannel>>
        {
            NONE{

                @Override
                public int compare(Map.Entry<String, DisplayChannel> o1, Map.Entry<String, DisplayChannel> o2) {
                    throw new UnsupportedOperationException("This value indicates no sorting");
                }
            }
            ,
            ALPHABETIC{

                @Override
                public int compare(Map.Entry<String, DisplayChannel> e1, Map.Entry<String, DisplayChannel> e2) {
                    return e1.getKey().compareTo(e2.getKey());
                }
            };


            @Override
            public abstract int compare(Map.Entry<String, DisplayChannel> var1, Map.Entry<String, DisplayChannel> var2);
        }
    }

    private class InterNode
    extends Node {
        protected final String LAZY = "-";
        protected InterNodeDescriptor desc;
        protected Collection<Map.Entry<String, DisplayChannel>> data;

        InterNode(String name) {
            super(name);
            this.LAZY = "-";
        }

        /*
         * WARNING - void declaration
         */
        void build(Collection<Map.Entry<String, DisplayChannel>> data) {
            InterNodeDescriptor.Sort sortAlgorithm;
            ArrayList<Map.Entry<String, DisplayChannel>> processedData;
            Serializable sz;
            this.data = data;
            String pathKey = this.getPathString();
            TreeMap<String, Serializable> nodes = LazyTreeView.this.getDescriptor().getNodes();
            Serializable serializable = sz = nodes == null ? null : nodes.get(pathKey);
            if (sz instanceof InterNodeDescriptor) {
                this.desc = (InterNodeDescriptor)sz;
            } else {
                this.desc = new InterNodeDescriptor();
                if (this == LazyTreeView.this.root) {
                    this.desc.setExpanded(true);
                }
            }
            if (!this.desc.isExpanded()) {
                this.add(new Node("-"));
                return;
            }
            if (this.desc.isSection()) {
                processedData = new ArrayList(data.size());
                for (Map.Entry<String, DisplayChannel> e : data) {
                    String processedKey = e.getKey().replaceFirst("/+", "//");
                    processedData.add(new AbstractMap.SimpleImmutableEntry<String, DisplayChannel>(processedKey, e.getValue()));
                }
            } else {
                processedData = new ArrayList<Map.Entry<String, DisplayChannel>>(data);
            }
            if (!InterNodeDescriptor.Sort.NONE.equals(sortAlgorithm = this.desc.getSort())) {
                processedData.sort(sortAlgorithm);
            }
            if (this.desc.isFlat()) {
                Object key = this.getPathString();
                if (!((String)key).isEmpty()) {
                    key = (String)key + "/";
                }
                key = (String)key + SectionedTable.class.getName();
                Serializable disDesc = nodes == null ? null : nodes.get(key);
                SectionedTable.Descriptor descriptor = !(disDesc instanceof SectionedTable.Descriptor) ? null : (SectionedTable.Descriptor)disDesc;
                SectionedTable tableModel = SectionedTable.getInstance(processedData, this.desc.isCompact() ? LazyTreeView.this.compactFields : LazyTreeView.this.fields, descriptor);
                MonitorTableNode monitorTableNode = new MonitorTableNode(tableModel);
                tableModel.setListener(monitorTableNode);
                this.add(monitorTableNode);
            } else {
                Object tableModel;
                ArrayList<Map.Entry<String, DisplayChannel>> leaves = new ArrayList<Map.Entry<String, DisplayChannel>>(processedData.size());
                ArrayList<Map.Entry<String, DisplayChannel>> mesh = new ArrayList<Map.Entry<String, DisplayChannel>>(processedData.size());
                LinkedHashMap branches = new LinkedHashMap();
                for (Map.Entry<String, DisplayChannel> entry : processedData) {
                    String[] pathSegments = entry.getKey().split("/+");
                    if (pathSegments.length < 2) {
                        leaves.add(entry);
                        continue;
                    }
                    if (this.desc.isMesh() && (pathSegments.length == 2 || pathSegments.length == 3)) {
                        void var11_14;
                        if (this.desc.isFlip()) {
                            String dp = pathSegments.length == 2 ? pathSegments[1] + "/" + pathSegments[0] : pathSegments[0] + "/" + pathSegments[2] + "/" + pathSegments[1];
                            AbstractMap.SimpleImmutableEntry<CallSite, DisplayChannel> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<CallSite, DisplayChannel>((CallSite)((Object)dp), entry.getValue());
                        }
                        mesh.add((Map.Entry<String, DisplayChannel>)var11_14);
                        continue;
                    }
                    ArrayList<AbstractMap.SimpleImmutableEntry<String, DisplayChannel>> branch = (ArrayList<AbstractMap.SimpleImmutableEntry<String, DisplayChannel>>)branches.get(pathSegments[0]);
                    if (branch == null) {
                        branch = new ArrayList<AbstractMap.SimpleImmutableEntry<String, DisplayChannel>>();
                        branches.put(pathSegments[0], branch);
                    }
                    StringJoiner sj = new StringJoiner("/");
                    for (int i = 1; i < pathSegments.length; ++i) {
                        sj.add(pathSegments[i]);
                    }
                    branch.add(new AbstractMap.SimpleImmutableEntry<String, DisplayChannel>(sj.toString(), entry.getValue()));
                }
                if (!leaves.isEmpty()) {
                    tableModel = SectionedTable.getInstance(leaves, this.desc.isCompact() ? LazyTreeView.this.compactFields : LazyTreeView.this.fields, null);
                    MonitorTableNode monitorTableNode = new MonitorTableNode((MonitorTable)tableModel);
                    ((MonitorTable)tableModel).setListener(monitorTableNode);
                    this.add(monitorTableNode);
                }
                if (!mesh.isEmpty()) {
                    tableModel = MeshTable.getInstance(mesh, this.desc.isCompact() ? LazyTreeView.this.compactFields : LazyTreeView.this.fields);
                    MonitorTableNode monitorTableNode = new MonitorTableNode((MonitorTable)tableModel);
                    ((MonitorTable)tableModel).setListener(monitorTableNode);
                    this.add(monitorTableNode);
                }
                if (!branches.isEmpty()) {
                    for (Map.Entry entry : branches.entrySet()) {
                        InterNode child = new InterNode((String)entry.getKey());
                        this.add(child);
                        ((ArrayList)entry.getValue()).trimToSize();
                        child.build((Collection)entry.getValue());
                    }
                }
            }
        }

        protected void rebuild() {
            if (this.data != null && !this.data.isEmpty()) {
                this.desc.setExpanded(true);
                Collection<Map.Entry<String, DisplayChannel>> data = this.data;
                LazyTreeView.this.updateDescriptor(this);
                this.clear();
                this.build(data);
                LazyTreeView.this.treeModel.nodeStructureChanged(this);
                this.restoreExpansion();
            }
        }

        @Override
        void clear() {
            super.clear();
            this.data = null;
        }

        @Override
        InterNodeDescriptor save() {
            return this.desc.getFlags() == 0 ? null : this.desc.clone();
        }

        void restoreExpansion() {
            Enumeration<TreeNode> en = this.depthFirstEnumeration();
            while (en.hasMoreElements()) {
                TreeNode node = en.nextElement();
                if (!(node instanceof InterNode)) continue;
                InterNode n = (InterNode)node;
                if (!n.desc.isExpanded()) continue;
                LazyTreeView.this.tree.expandPath(new TreePath(n.getPath()));
            }
        }

        boolean isLazy() {
            return this.children != null && this.children.size() == 1 && ((TreeNode)this.children.get(0)).toString().equals("-");
        }

        public InterNodeDescriptor getDescriptor() {
            return this.desc;
        }
    }

    class TreeEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final TreeRenderer renderer;
        private Object editorValue;
        private final JPopupMenu popup;
        private final Action compactAct;
        private final Action sectionAct;
        private final EnumMap<InterNodeDescriptor.DisplayMode, AbstractAction> modeAct;
        private final EnumMap<InterNodeDescriptor.Sort, AbstractAction> sortAct;

        public TreeEditor() {
            JCheckBoxMenuItem menuItem;
            AbstractAction act;
            this.renderer = new TreeRenderer();
            this.popup = new JPopupMenu();
            JMenu menu = new JMenu("Display mode...");
            this.modeAct = new EnumMap(InterNodeDescriptor.DisplayMode.class);
            for (final InterNodeDescriptor.DisplayMode displayMode : InterNodeDescriptor.DisplayMode.values()) {
                act = new AbstractAction(displayMode.toString()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (TreeEditor.this.editorValue instanceof InterNode) {
                            InterNode node = (InterNode)TreeEditor.this.editorValue;
                            TreeEditor.this.modeAct.values().forEach(act -> act.putValue("SwingSelectedKey", act.equals(this)));
                            node.getDescriptor().setDisplayMode(displayMode);
                            node.rebuild();
                        }
                    }
                };
                this.modeAct.put(displayMode, act);
                menuItem = new JCheckBoxMenuItem(act);
                menu.add(menuItem);
            }
            this.popup.add(menu);
            menu = new JMenu("Order...");
            this.sortAct = new EnumMap(InterNodeDescriptor.Sort.class);
            for (Enum enum_ : InterNodeDescriptor.Sort.values()) {
                act = new AbstractAction(enum_.toString()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (TreeEditor.this.editorValue instanceof InterNode) {
                            InterNode node = (InterNode)TreeEditor.this.editorValue;
                            InterNodeDescriptor.Sort selectedMode = null;
                            for (Map.Entry<InterNodeDescriptor.Sort, AbstractAction> ee : TreeEditor.this.sortAct.entrySet()) {
                                AbstractAction action = ee.getValue();
                                boolean isChosen = action == this;
                                action.putValue("SwingSelectedKey", isChosen);
                                if (!isChosen) continue;
                                selectedMode = ee.getKey();
                            }
                            node.getDescriptor().setSort(selectedMode);
                            node.rebuild();
                        }
                    }
                };
                this.sortAct.put((InterNodeDescriptor.Sort)enum_, act);
                menuItem = new JCheckBoxMenuItem(act);
                menu.add(menuItem);
            }
            this.popup.add(menu);
            this.compactAct = new AbstractAction("Compact"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TreeEditor.this.editorValue instanceof InterNode) {
                        InterNode node = (InterNode)TreeEditor.this.editorValue;
                        Boolean v = (Boolean)this.getValue("SwingSelectedKey");
                        node.getDescriptor().setCompact(Boolean.TRUE.equals(v));
                        node.rebuild();
                    }
                }
            };
            menuItem = new JCheckBoxMenuItem(this.compactAct);
            this.popup.add(menuItem);
            this.sectionAct = new AbstractAction("Sectioned"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TreeEditor.this.editorValue instanceof InterNode) {
                        InterNode node = (InterNode)TreeEditor.this.editorValue;
                        Boolean v = (Boolean)this.getValue("SwingSelectedKey");
                        node.getDescriptor().setSection(Boolean.TRUE.equals(v));
                        node.rebuild();
                    }
                }
            };
            menuItem = new JCheckBoxMenuItem(this.sectionAct);
            this.popup.add(menuItem);
            this.renderer.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                private void maybeShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        TreeEditor.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.editorValue = value;
            if (this.editorValue instanceof InterNode) {
                InterNode node = (InterNode)this.editorValue;
                this.compactAct.putValue("SwingSelectedKey", node.getDescriptor().isCompact());
                this.sectionAct.putValue("SwingSelectedKey", node.getDescriptor().isSection());
                for (Map.Entry<InterNodeDescriptor.DisplayMode, AbstractAction> entry : this.modeAct.entrySet()) {
                    entry.getValue().putValue("SwingSelectedKey", entry.getKey().equals((Object)node.getDescriptor().getDisplayMode()));
                }
                for (Map.Entry<Enum, AbstractAction> entry : this.sortAct.entrySet()) {
                    entry.getValue().putValue("SwingSelectedKey", ((InterNodeDescriptor.Sort)entry.getKey()).equals(node.getDescriptor().getSort()));
                }
            }
            return this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorValue;
        }
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        TreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof DisplayNode) {
                DisplayNode node = (DisplayNode)value;
                return node.getComponent();
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
    }
}

