/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.sal.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;
import org.lsst.ccs.camera.sal.xml.util.ChecksumExtractorUtils;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

public class ChecksumCrossCheckTest {
    @Test
    public void testAuxTelTelemetryChecksums() throws IOException, ClassNotFoundException, ParserConfigurationException, SAXException, DOMException, XPathExpressionException {
        this.testChecksums(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY, "/xml/ATCamera/ATCamera_Telemetry.xml");
    }

    @Test
    public void testAuxTelEventChecksums() throws IOException, ClassNotFoundException, ParserConfigurationException, SAXException, DOMException, XPathExpressionException {
        this.testChecksums(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED, "/xml/ATCamera/ATCamera_Events.xml");
    }

    @Test
    public void testComCamTelemetryChecksums() throws IOException, ClassNotFoundException, ParserConfigurationException, SAXException, DOMException, XPathExpressionException {
        this.testChecksums(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY, "/xml/CCCamera/CCCamera_Telemetry.xml");
    }

    @Test
    public void testComCamEventChecksums() throws IOException, ClassNotFoundException, ParserConfigurationException, SAXException, DOMException, XPathExpressionException {
        this.testChecksums(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED, "/xml/CCCamera/CCCamera_Events.xml");
    }

    @Test
    public void testCameraTelemetryChecksums() throws IOException, ClassNotFoundException, ParserConfigurationException, SAXException, DOMException, XPathExpressionException {
        this.testChecksums(Camera.MAIN_CAMERA, XMLMaker2.SALType.TELEMETRY, "/xml/MTCamera/MTCamera_Telemetry.xml");
    }

    @Test
    public void testCameraEventChecksums() throws IOException, ClassNotFoundException, ParserConfigurationException, SAXException, DOMException, XPathExpressionException {
        this.testChecksums(Camera.MAIN_CAMERA, XMLMaker2.SALType.SETTINGS_APPLIED, "/xml/MTCamera/MTCamera_Events.xml");
    }

    private void testChecksums(Camera camera, XMLMaker2.SALType salType, String xmlFile) throws IOException, ClassNotFoundException, ParserConfigurationException, SAXException, DOMException, XPathExpressionException {
        ChecksumExtractorUtils extractor = new ChecksumExtractorUtils();
        Map<String, Long> dictionaryChecksums = ChecksumCrossCheckTest.readDictionariesAndExtractChecksums(extractor, camera, salType);
        Map<String, Long> xmlChecksums = ChecksumCrossCheckTest.readXMLAndExtractChecksums(extractor, xmlFile);
        for (Map.Entry<String, Long> entry : dictionaryChecksums.entrySet()) {
            String topic = entry.getKey();
            Long checksum = entry.getValue();
            Long xmlChecksum = xmlChecksums.get(topic + salType.getClassNameAppendage());
            System.out.printf("%s %d %d %s\n", topic, checksum, xmlChecksum, Objects.equals(checksum, xmlChecksum) ? "" : "!!!");
            if (xmlChecksum == null) continue;
            Assert.assertEquals((String)("Checksum mismatch for topic: " + topic), (Object)checksum, (Object)xmlChecksum);
        }
    }

    private static Map<String, Long> readXMLAndExtractChecksums(ChecksumExtractorUtils extractor, String xmlFile) throws ParserConfigurationException, IOException, DOMException, SAXException, XPathExpressionException {
        try (InputStream is = ChecksumCrossCheckTest.class.getResourceAsStream(xmlFile);){
            Assert.assertNotNull((Object)is);
            Map map = extractor.extractChecksumsFromSALXMLInputStream(is);
            return map;
        }
    }

    private static Map<String, Long> readDictionariesAndExtractChecksums(ChecksumExtractorUtils extractor, Camera camera, XMLMaker2.SALType salType) throws ClassNotFoundException, IOException {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        MakeXMLConfiguration config = MakeXMLConfiguration.getInstance((Camera)camera, (XMLMaker2.SALType)salType);
        for (MakeXMLConfiguration.DictionaryConfiguration dict : config.getOrderedListOfDictionaryConfigurations()) {
            result.putAll(extractor.extractChecksumsFromDictionaryConfiguration(dict, config.getMapping()));
        }
        return result;
    }
}

