/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.sal.xml;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;
import org.lsst.ccs.camera.sal.xml.maker.MakeAllXML;
import org.lsst.ccs.camera.sal.xml.maker.OrderedProperties;
import org.xml.sax.SAXException;

public class MakeAllXMLTest {
    @Test
    public void testAllAuxTelTelemetryXML() throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        MakeAllXMLTest.testAllXML(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY);
    }

    @Test
    public void testAllAuxTelConfigurationXML() throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        MakeAllXMLTest.testAllXML(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED);
    }

    @Test
    public void testAllComCamTelemetryXML() throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        MakeAllXMLTest.testAllXML(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY);
    }

    @Test
    public void testAllComCamConfigurationXML() throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        MakeAllXMLTest.testAllXML(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED);
    }

    @Test
    public void testAllCameraTelemetryXML() throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        MakeAllXMLTest.testAllXML(Camera.MAIN_CAMERA, XMLMaker2.SALType.TELEMETRY);
    }

    @Test
    public void testAllCameraConfigurationXML() throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        MakeAllXMLTest.testAllXML(Camera.MAIN_CAMERA, XMLMaker2.SALType.SETTINGS_APPLIED);
    }

    private static void testAllXML(Camera camera, XMLMaker2.SALType saltype) throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, XPathExpressionException {
        Map computed = MakeAllXML.computeChecksumsForAllXML((Camera)camera, (XMLMaker2.SALType)saltype);
        String fileName = MakeAllXML.getChecksumsFile((Camera)camera, (XMLMaker2.SALType)saltype);
        String message = MakeAllXML.getChecksumsMessage((Camera)camera, (XMLMaker2.SALType)saltype);
        OrderedProperties.store((Map)computed, (PrintStream)System.out, (String)message);
        Map read = MakeAllXML.extractChecksumsForXMLFile((String)fileName);
        for (String key : computed.keySet()) {
            Assert.assertEquals((String)(message + " Component: " + key), computed.get(key), read.get(key));
        }
    }
}

