package org.lsst.ccs.bus.states;

/**
 * A version of the StateBundle that cannot be modified.
 * 
 * This object is used on the client side by the AgentStateService during
 * the BusMessage pre-processing step.
 * 
 * The modifiable StateBundle sent with the StatusMessage is replaced by this
 * unmodifiable version.
 * 
 * In the future we should publish the unmodifiable version directly.
 * 
 * @author The LSST CCS Team
 */
public class UnmodifiableStateBundle extends StateBundle {


    /** 
     * Constructs an UnmodifiableStateBundle from the original StateBundle.
     * 
     * @param originalStateBundle The original StateBundle.
     */
    public UnmodifiableStateBundle(StateBundle originalStateBundle) {
        allStates.putAll(originalStateBundle.allStates);
        originalStateBundle.componentStates.forEach(
                (name,stateBundle) -> { componentStates.put(name, new UnmodifiableStateBundle(stateBundle));}
        );
        if ( !originalStateBundle.subsystemSpecificStates.isEmpty() ) {
            subsystemSpecificStates.putAll(originalStateBundle.subsystemSpecificStates);
        }
    }

    //Make this class unmodifiable
    @Override
    protected void innerSetState(Enum state) {
        throw new UnsupportedOperationException("This instance of StateBundle cannot be modified");
    }
    
    //Make this class unmodifiable
    @Override
    protected void innerSetComponentState(String component, Enum... states) {        
        throw new UnsupportedOperationException("This instance of StateBundle cannot be modified");
    }

}
