package org.lsst.ccs.bus.states;

/**
 * The Configuration state of a subsystem reflects the state of its set of
 * configurable parameters.
 * The Agent State Diagrams can be viewed at https://confluence.slac.stanford.edu/display/LSSTCAM/State+Diagrams
 * @author The LSST CCS Team
 */
public enum ConfigurationState implements AgentState {
    
    /**
     * The initial Configuration State. The Agent is in UNCONFIGURED state
     * only during the startup procedure up to the point the Agent becomes
     * CONFIGURED.
     */
    UNCONFIGURED,
    
    /**
     * The current configuration state is fully backed up by the configuration system.
     */
    CONFIGURED,
    
    /**
     * The current configuration state has been modified and not saved yet.
     */
    DIRTY,
    
    /**
     * The subsystem is safe configured by a local porperties file.
     */
    @Deprecated
    INITIAL_SAFE;
}
