package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.Map;
import java.util.Map.Entry;

/**
 * An alert standing for CCS version incompatibilities detected on the buses.
 * @author LSST CCS Team
 */
public enum AgentAlerts {


    ClusterAlert("ClusterAlert","Alert raised when de serialization problems are detected on the buses"),
    
    ClusterViewAlert("ClusterViewAlert","Alert raised when there are problems with the Cluster View"),

    RuntimeAlert("RuntimeAlert","Alert raised when there are problems with the java runtime environment");

    private final String id, description;

    AgentAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getAlertId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert getAlert() {
        return getAlert(null);
    }

    public Alert getAlert(Map<String,Object> alertData) {
        Alert a = new Alert(id,description);
        if ( alertData != null ) {
            for (Entry<String, Object> e : alertData.entrySet()) {
                a.addAlertData(e.getKey(), (Serializable) e.getValue());
            }
        }
        return a;
    }
    
}
