package org.lsst.ccs.bus.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation for classes or fields that are not to be encoded.
 * Individually annotated fields, or all the fields of an annotated class will
 * not be encoded and will not be added to the data dictionary. This makes them
 * invisible to all CCS applications that rely on the generic encoding mechanism.
 * The only way to access these fields is to access the published object with
 * the class definition.
 * In other words, these fields are meant to be a private exchange between the 
 * publisher and a specific client.
 * Fields annotated this way will not be available to the StatusAggregator nor to 
 * generic monitoring/configuration panels in ccs-consoles.
 *
 * @author The LSST CCS Team
 */
@Target({ElementType.FIELD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface SkipEncoding {

}
