package org.lsst.ccs.bus.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation for classes or fields that are not to be trended.
 * When this annotation is present, the class fields will be added to the
 * data dictionary with a dedicated attribute to instruct the CCS local database
 * not to store the quantity.
 * Since these fields are part of the data dictionary, they will be still available
 * to other CCS applications that listen to encoded data, like ccs-consoles and
 * the StatusAggregator.
 * 
 *
 * @author The LSST CCS Team
 */
@Target({ElementType.FIELD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface DoNotTrend {
    
}
