/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertInstance;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class RaisedAlertHistory
implements Serializable {
    private static final long serialVersionUID = 423621057372456934L;
    private Alert latestAlert;
    private final List<RaisedAlertInstance> instances;
    private AlertState highestSeverity = AlertState.NOMINAL;
    private Alert highestSeverityAlert;
    private Acknowledgement ack;

    public RaisedAlertHistory() {
        this.instances = new ArrayList<RaisedAlertInstance>(1);
    }

    public RaisedAlertHistory(RaisedAlertHistory raisedAlertHistory) {
        this();
        this.latestAlert = raisedAlertHistory.latestAlert;
        this.instances.addAll(raisedAlertHistory.instances);
        this.highestSeverity = raisedAlertHistory.highestSeverity;
        this.highestSeverityAlert = raisedAlertHistory.highestSeverityAlert;
        this.ack = raisedAlertHistory.ack;
    }

    public Alert getLatestAlert() {
        return this.latestAlert;
    }

    public void addAlertInstance(AlertState severity, Alert alert, CCSTimeStamp ccsTimeStamp, String cause, int count) {
        if (severity.compareTo(this.highestSeverity) > 0) {
            this.highestSeverity = severity;
            this.highestSeverityAlert = alert;
        }
        if (this.highestSeverityAlert == null) {
            this.highestSeverityAlert = alert;
        }
        this.instances.add(new RaisedAlertInstance(severity, ccsTimeStamp, cause, count));
        if (this.instances.size() > 10) {
            for (int i = 9; i < this.instances.size(); ++i) {
                this.instances.remove(0);
            }
        }
        if (severity != AlertState.NOMINAL) {
            this.ack = null;
        }
        this.latestAlert = alert;
    }

    public boolean addAcknowledgement(String message, String user) {
        if (this.ack == null) {
            this.ack = new Acknowledgement(message, user, this);
            return true;
        }
        return false;
    }

    public boolean removeAcknowledgement() {
        if (this.ack == null) {
            return false;
        }
        this.ack = null;
        return true;
    }

    public int getNumberOfInstances() {
        return this.instances.size();
    }

    public int getAccumulatedNumberOfInstances() {
        return this.instances.stream().collect(Collectors.summingInt(RaisedAlertInstance::getCount));
    }

    public AlertState getLatestAlertState() {
        int n = this.getNumberOfInstances();
        return switch (n) {
            case 0 -> AlertState.NOMINAL;
            default -> this.instances.get(n - 1).getAlertState();
        };
    }

    public CCSTimeStamp getLatestAlertCCSTimeStamp() {
        int n = this.getNumberOfInstances();
        return switch (n) {
            case 0 -> null;
            default -> this.instances.get(n - 1).getCCSTimeStamp();
        };
    }

    public String getLatestAlertCause() {
        int n = this.getNumberOfInstances();
        return switch (n) {
            case 0 -> "";
            default -> this.instances.get(n - 1).getCause();
        };
    }

    public RaisedAlertInstance getLatestAlertInstance() {
        int n = this.getNumberOfInstances();
        return switch (n) {
            case 0 -> null;
            default -> this.instances.get(n - 1);
        };
    }

    public AlertState getHighestAlertState() {
        return this.highestSeverity;
    }

    public Alert getHighestAlert() {
        return this.highestSeverityAlert;
    }

    public ArrayList<RaisedAlertInstance> getRaisedAlertInstancesList() {
        return new ArrayList<RaisedAlertInstance>(this.instances);
    }

    public boolean isAcknowledged() {
        return this.ack != null;
    }

    public Acknowledgement getAcknowledgement() {
        return this.ack;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Raised Alarms for id ").append(this.getLatestAlert().getAlertId()).append("\n");
        sb.append("Overall Severity: ").append(this.getHighestAlertState());
        return sb.toString();
    }

    public void setHighestSeverit(AlertState highestSeverity) {
        this.highestSeverity = highestSeverity;
    }

    public static class Acknowledgement
    implements Serializable {
        public final String message;
        public final String user;
        public final long time;
        public final AlertState highestSeverity;
        public final AlertState latestSeverity;

        public Acknowledgement(String message, String user, RaisedAlertHistory history) {
            this.message = message;
            this.user = user;
            this.time = System.currentTimeMillis();
            this.highestSeverity = history.getHighestAlertState();
            this.latestSeverity = history.getLatestAlertState();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Acknowledged by ").append(this.user).append(". ").append(this.message);
            return sb.toString();
        }
    }
}

