/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.alerts.DeviceAlerts;
import org.lsst.ccs.bus.alerts.InfrastructureAlert;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.MutedAlertRequest;

public class MutedAlertRequestTest {
    @Test
    public void testMutedAlertRequest() throws Exception {
        MutedAlertRequest marAll = new MutedAlertRequest("testSub", ".*", 5, "ccs");
        MutedAlertRequest marOffline = new MutedAlertRequest("testSub", ".*Offline.*", 5, "ccs");
        Alert deviceOffline = DeviceAlerts.DEVICE_OFFLINE.newAlert("dev");
        Alert periodicTask = InfrastructureAlert.PERIODIC_TASK_SKIPPED.getAlert();
        Assert.assertTrue((boolean)marAll.isSubsystemAlertMuted("testSub", deviceOffline));
        Assert.assertTrue((boolean)marAll.isSubsystemAlertMuted("testSub", periodicTask));
        Assert.assertTrue((boolean)marOffline.isSubsystemAlertMuted("testSub", deviceOffline));
        Assert.assertFalse((boolean)marOffline.isSubsystemAlertMuted("testSub", periodicTask));
        Assert.assertTrue((boolean)marAll.isAlertIdMuted("testSub/" + deviceOffline.getAlertId()));
        Assert.assertTrue((boolean)marAll.isAlertIdMuted("testSub/" + periodicTask.getAlertId()));
        Assert.assertTrue((boolean)marOffline.isAlertIdMuted("testSub/" + deviceOffline.getAlertId()));
        Assert.assertFalse((boolean)marOffline.isAlertIdMuted("testSub/" + periodicTask.getAlertId()));
        while (marAll.isValid() || marOffline.isValid()) {
            Thread.sleep(1000L);
        }
        Assert.assertFalse((boolean)marAll.isSubsystemAlertMuted("testSub", deviceOffline));
        Assert.assertFalse((boolean)marAll.isSubsystemAlertMuted("testSub", periodicTask));
        Assert.assertFalse((boolean)marOffline.isSubsystemAlertMuted("testSub", deviceOffline));
        Assert.assertFalse((boolean)marOffline.isSubsystemAlertMuted("testSub", periodicTask));
        Assert.assertFalse((boolean)marAll.isAlertIdMuted("testSub/" + deviceOffline.getAlertId()));
        Assert.assertFalse((boolean)marAll.isAlertIdMuted("testSub/" + periodicTask.getAlertId()));
        Assert.assertFalse((boolean)marOffline.isAlertIdMuted("testSub/" + deviceOffline.getAlertId()));
        Assert.assertFalse((boolean)marOffline.isAlertIdMuted("testSub/" + periodicTask.getAlertId()));
    }
}

