/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.states.ConfigurationState;

public class ConfigurationInfoTest {
    @Test
    public void test1() {
        ConfigurationInfo ci = new ConfigurationInfo.Builder().setConfigurationState(ConfigurationState.CONFIGURED).setDescription("descriptionName").build();
        Assert.assertEquals((Object)"descriptionName", (Object)ci.getDescriptionName());
        ci = new ConfigurationInfo.Builder().setConfigurationState(ConfigurationState.DIRTY).setDescription("descriptionName").updateConfigurationDescription("[volt:s1/hi(u),someCat:s2/normal(u)*]", "[volt:hi(u),someCat:normal(u)*]").build();
        Assert.assertEquals((Object)"descriptionName", (Object)ci.getDescriptionName());
        Assert.assertTrue((boolean)ci.hasChanges());
        Assert.assertTrue((boolean)ci.hasCategory("volt"));
        Assert.assertEquals((Object)"volt:s1/hi(u)", (Object)ci.getConfigurationDescriptionObject().getCategoryTag("volt").convertToString(true));
        Assert.assertEquals((Object)"someCat:s2/normal(u)*", (Object)ci.getConfigurationDescriptionObject().getCategoryTag("someCat").toString());
        ci = new ConfigurationInfo.Builder().setConfigurationState(ConfigurationState.DIRTY).setDescription("descriptionName").updateConfigurationDescription("[volt:s1/hi(3),:s2/normal(4)*", "[volt:hi(3),:normal(4)*").addParameter("someComp/parm1", Integer.class, "", "", false, false, false).updateParameter("someComp/parm1", "1", "11", true).addParameter("someComp/parm2", String.class, "A", "", false, false, false).updateParameter("someComp/parm2", "2", "22", true).addParameter("someComp/parm3", String.class, "B", "", false, false, false).updateParameter("someComp/parm3", "3", "33", true).addParameter("otherComp/parm1", Double.class, "", "", false, false, false).updateParameter("otherComp/parm1", "1", "11", true).addParameter("otherComp/parm2", String.class, "A", "", false, false, false).updateParameter("otherComp/parm2", "2", "22", true).addParameter("otherComp/parm3", String.class, "B", "", false, false, false).updateParameter("otherComp/parm3", "3", "33", true).addRecentChange("someComp/parm1").addRecentChange("someComp/parm2").build();
        Map res = ConfigurationInfo.getParameterInfoGroupByCategory((List)ci.getAllParameterInfo());
        Assert.assertEquals((long)2L, (long)((List)res.get("")).size());
        Assert.assertEquals((long)2L, (long)((List)res.get("A")).size());
        Assert.assertEquals((long)2L, (long)((List)res.get("B")).size());
        res = ConfigurationInfo.getParameterInfoGroupByComponent((List)ci.getAllParameterInfo());
        Assert.assertEquals((long)3L, (long)((List)res.get("someComp")).size());
        Assert.assertEquals((long)3L, (long)((List)res.get("otherComp")).size());
        Map currVals = ci.getCurrentValuesFor("someComp");
        Assert.assertEquals((String)"someComp size", (long)3L, (long)currVals.size());
        Assert.assertEquals((Object)"11", currVals.get("parm1"));
        Assert.assertEquals((Object)"22", currVals.get("parm2"));
        Assert.assertEquals((Object)"33", currVals.get("parm3"));
        currVals = ci.getCurrentValuesForCategory("A");
        Assert.assertEquals((String)"category A size", (long)2L, (long)currVals.size());
        Assert.assertEquals((Object)"22", currVals.get("someComp/parm2"));
        Assert.assertEquals((Object)"22", currVals.get("otherComp/parm2"));
    }
}

