package org.lsst.ccs.bus.messages;

import java.time.Duration;


/**
 * Command ACK.
 * Returned when a CommandRequest has been accepted and the recipient will carry
 * out the corresponding execution.
 * 
 * @author LSST CCS Team
 */
public final class CommandAck extends CommandReply<String> {
    
    private final Duration timeout;
    
    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 95452495415777347L;

    /**
     * CommandAcks are constructed from the corresponding CommandRequest. 
     * @param command The CommandRequest for which this CommandAck is being sent.
     * @param timeout Timeout to be used.
     */
    public CommandAck(CommandRequest command, Duration timeout) {
        super(command, "OK");
        this.timeout = timeout;
    }

    /**
     * Returns the timeout value for the command suggested by the command target.
     * Non-positive or {@code null} timeout indicates the default should be used.
     * @return the suggested timeout. 
     */
    public Duration getTimeout() {
        return timeout;
    }

    @Override
    public String toString() {
        String origin = getOriginAgentInfo() != null ? getOriginAgentInfo().getName() : "notSet";
        return getClass().getName() + "(from " + origin + ")";
    }

}
