/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.function.Function;
import org.junit.Assert;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;

public class DataProviderDictionaryTest {
    private List<DataProviderInfo> d0;
    private List<DataProviderInfo> d1;

    public List<DataProviderInfo> sampleDictionary0() {
        if (this.d0 != null) {
            return this.d0;
        }
        this.d0 = new LinkedList<DataProviderInfo>();
        String path = "a0";
        String key = "";
        HashMap<DataProviderInfo.Attribute, String> att = new HashMap<DataProviderInfo.Attribute, String>();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "a0/b1";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "a0/a1";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "a0/c1";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        att.put(DataProviderInfo.Attribute.DESCRIPTION, "L");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "a00/a01/m";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        att.put(DataProviderInfo.Attribute.DESCRIPTION, "L");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "a00/a01/d";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        att.put(DataProviderInfo.Attribute.DESCRIPTION, "L");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "b0/b1";
        key = "b1";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "b0/b2";
        key = "b2";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "b0/b1/b3/a4";
        key = "";
        att = null;
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "b0/b1/b3/b4";
        key = "";
        att = null;
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "b0/b2/b3/a4";
        key = "";
        att = null;
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "b0/b2/b3/b4";
        key = "";
        att = null;
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "d0/d1";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        att.put(DataProviderInfo.Attribute.DESCRIPTION, "Desc main");
        att.put(DataProviderInfo.Attribute.UNITS, "inch");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "d0/d1";
        key = "limitHigh";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "C");
        att.put(DataProviderInfo.Attribute.UNITS, "inch");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "d0/d1";
        key = "limitLow";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "C");
        att.put(DataProviderInfo.Attribute.UNITS, "inch");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "d0/d2";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        att.put(DataProviderInfo.Attribute.DESCRIPTION, "Desc main");
        att.put(DataProviderInfo.Attribute.UNITS, "inch");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "d0/d2";
        key = "limitHigh";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "C");
        att.put(DataProviderInfo.Attribute.UNITS, "inch");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "d0/d2";
        key = "limitLow";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "C");
        att.put(DataProviderInfo.Attribute.UNITS, "inch");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "e00/e10/e20";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "C");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "e00/e11/e20";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "a00/a04/m";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        att.put(DataProviderInfo.Attribute.DESCRIPTION, "L");
        this.d0.add(new DataProviderInfo(path, key, att));
        path = "a00/a04/v";
        key = "";
        att = new HashMap();
        att.put(DataProviderInfo.Attribute.TYPE, "M");
        att.put(DataProviderInfo.Attribute.DESCRIPTION, "L");
        this.d0.add(new DataProviderInfo(path, key, att));
        return this.d0;
    }

    public List<DataProviderInfo> sampleDictionary1() {
        if (this.d1 != null) {
            return this.d1;
        }
        int maxPathLength = 10;
        int nEntries = 10000;
        int nSegments = 20;
        ArrayList<String> segments = new ArrayList<String>(nSegments);
        int start = 65;
        for (int i = 0; i < nSegments; ++i) {
            segments.add(String.valueOf((char)(start + i)));
        }
        Random rand = new Random();
        HashSet<String> paths = new HashSet<String>();
        this.d1 = new LinkedList<DataProviderInfo>();
        for (int i = 0; i < nEntries; ++i) {
            int pathLength = rand.nextInt(maxPathLength) + 1;
            ArrayList ss = new ArrayList(pathLength);
            while (pathLength-- > 0) {
                ss.add(segments.get(rand.nextInt(nSegments)));
            }
            String path = String.join((CharSequence)"/", ss);
            if (paths.contains(path)) continue;
            paths.add(path);
            HashMap<DataProviderInfo.Attribute, String> att = new HashMap<DataProviderInfo.Attribute, String>();
            if (rand.nextInt(10) == 0) {
                att.put(DataProviderInfo.Attribute.TYPE, "M");
            }
            this.d1.add(new DataProviderInfo(path, "", att));
        }
        System.out.println("Created sample dictionary of length " + this.d1.size());
        return this.d1;
    }

    public static void testGetDataProviderInfoForPath(List<DataProviderInfo> input, DataProviderDictionary dictionary) {
        DataProviderInfo dOut;
        for (DataProviderInfo dataProviderInfo : input) {
            dOut = dictionary.getDataProviderInfoForPath(dataProviderInfo.getFullPath());
            Assert.assertEquals((Object)dataProviderInfo, (Object)dOut);
        }
        for (DataProviderInfo dataProviderInfo : dictionary.getDataProviderInfos()) {
            dOut = dictionary.getDataProviderInfoForPath(dataProviderInfo.getFullPath());
            Assert.assertEquals((Object)dataProviderInfo, (Object)dOut);
        }
        String[] nonExistentPaths = new String[]{"plane/old/path", "b0", "a0/a1/x", "a0/a1/x/y"};
        try {
            for (String path : nonExistentPaths) {
                DataProviderInfo d = dictionary.getDataProviderInfoForPath(path);
                Assert.assertNull((String)("Non-null data for non-existing path " + path), (Object)d);
            }
        }
        catch (RuntimeException runtimeException) {
            Assert.fail((String)("Exception thrown while getting data for non-existing path " + runtimeException.toString()));
        }
    }

    public static void testGetDataProviderInfos(List<DataProviderInfo> input, DataProviderDictionary dictionary) {
        Assert.assertEquals((String)"Incorrect dictionary size", (long)input.size(), (long)dictionary.size());
        HashMap expResult = new HashMap();
        input.forEach(d -> expResult.put(d.getFullPath(), d));
        HashMap result = new HashMap();
        dictionary.getDataProviderInfos().forEach(d -> result.put(d.getFullPath(), d));
        Assert.assertEquals((String)"Unordered sets are not equal.", expResult, result);
        int n = input.size();
        ListIterator it = dictionary.getDataProviderInfos().listIterator();
        ArrayList forward = new ArrayList();
        while (it.hasNext()) {
            forward.add(it.next());
        }
        while (n-- > 0) {
            DataProviderInfo d2 = (DataProviderInfo)it.previous();
            Assert.assertEquals((String)("Failure at " + n), forward.get(n), (Object)d2);
            String path = d2.getFullPath();
            Assert.assertNotNull((String)("Unknown path: " + path), result.remove(path));
        }
        Assert.assertTrue((String)"Not all entries listed", (boolean)result.isEmpty());
    }

    public static void testGetDataProviderInfosOrder(List<DataProviderInfo> input, DataProviderDictionary dictionary) {
        List output = dictionary.getDataProviderInfos();
        Assert.assertEquals((String)"Ordered lists are not equal.", input, (Object)output);
    }

    public static DataProviderDictionary serDeser(DataProviderDictionary dictionary) {
        byte[] content = DataProviderDictionaryTest.serialize(dictionary);
        DataProviderDictionary d = DataProviderDictionaryTest.deserialize(content);
        return d;
    }

    public static byte[] serialize(DataProviderDictionary dictionary) {
        byte[] content = null;
        try {
            ByteArrayOutputStream outB = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(outB);
            out.writeObject(dictionary);
            out.close();
            outB.close();
            content = outB.toByteArray();
        }
        catch (Exception x) {
            Assert.fail((String)("Exception thrown while serializing " + dictionary.getClass().getSimpleName() + " : " + x.toString()));
        }
        return content;
    }

    public static DataProviderDictionary deserialize(byte[] serializedDictionary) {
        DataProviderDictionary d = null;
        try {
            ByteArrayInputStream inB = new ByteArrayInputStream(serializedDictionary);
            ObjectInputStream in = new ObjectInputStream(inB);
            d = (DataProviderDictionary)in.readObject();
            in.close();
            inB.close();
        }
        catch (Exception x) {
            Assert.fail((String)("Exception thrown while deserializing " + x.toString()));
        }
        return d;
    }

    public static void testFull(List<DataProviderInfo> input, Function<List<DataProviderInfo>, DataProviderDictionary> maker, boolean checkOrder) {
        DataProviderDictionary dictionary = maker.apply(input);
        if (checkOrder) {
            DataProviderDictionaryTest.testGetDataProviderInfosOrder(input, dictionary);
        } else {
            DataProviderDictionaryTest.testGetDataProviderInfos(input, dictionary);
        }
        DataProviderDictionaryTest.testGetDataProviderInfoForPath(input, dictionary);
        DataProviderDictionary dictCopy = DataProviderDictionaryTest.serDeser(dictionary);
        DataProviderDictionaryTest.testGetDataProviderInfosOrder(dictCopy.getDataProviderInfos(), dictionary);
        dictCopy = maker.apply(input);
        DataProviderDictionaryTest.testGetDataProviderInfosOrder(dictCopy.getDataProviderInfos(), dictionary);
        ArrayList<DataProviderInfo> shuffledInput = new ArrayList<DataProviderInfo>(input);
        Collections.shuffle(shuffledInput);
        dictCopy = maker.apply(shuffledInput);
        DataProviderDictionaryTest.testGetDataProviderInfoForPath(input, dictCopy);
    }
}

