package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.KeyValueDataList;

/**
 * A status message containing a DataProviderDictionary object.
 * 
 * @author The LSST CCS Team
 * 
 */
public final class StatusDataProviderDictionary extends StatusMessage<DataProviderDictionary,Object> {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -7413345286991L;

    /**
     * Create a StatusDataProviderDictionary message by providing the DataProviderDictionary.
     * @param ser The serialized DataProviderDictionary object to be sent.
     * 
     */
    public StatusDataProviderDictionary(byte[] ser, String compressionProtocol){
        super(DataProviderDictionary.class, ser, compressionProtocol);
    }
        
    /**
     * Get the DataProviderDictionary object contained in this message.
     * @return The DataProviderDictionary object embedded in the message.
     */
    public DataProviderDictionary getDataProviderDictionary() {
        return getObject();
    }

    @Override
    protected KeyValueDataList encodeObject(DataProviderDictionary obj) {
        return null;
    }
    
}
