/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class KeyValueData
implements Serializable {
    private static final long serialVersionUID = -24918287359238L;
    private final String key;
    private final Serializable value;
    private final long timestamp;
    private CCSTimeStamp ccsTimeStamp;
    private final KeyValueDataType type;

    @Deprecated
    public KeyValueData(String key, Serializable value, long timestamp, KeyValueDataType type) {
        this(key, value, CCSTimeStamp.currentTimeFromMillis((long)timestamp), type);
    }

    public KeyValueData(String key, Serializable value, CCSTimeStamp ccsTimeStamp, KeyValueDataType type) {
        this.key = key;
        this.value = value;
        this.timestamp = ccsTimeStamp.getUTCInstant().toEpochMilli();
        this.type = type;
        this.ccsTimeStamp = ccsTimeStamp;
    }

    @Deprecated
    public KeyValueData(String key, Serializable value, long timestamp) {
        this(key, value, timestamp, KeyValueDataType.KeyValueTrendingData);
    }

    public KeyValueData(String key, Serializable value, CCSTimeStamp ccsTimeStamp) {
        this(key, value, ccsTimeStamp, KeyValueDataType.KeyValueTrendingData);
    }

    public KeyValueData(String key, Serializable value) {
        this(key, value, CCSTimeStamp.currentTime());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public CCSTimeStamp getCCSTimeStamp() {
        return this.ccsTimeStamp;
    }

    public Serializable getValue() {
        return this.value;
    }

    public String getKey() {
        return this.key;
    }

    public KeyValueDataType getType() {
        return this.type;
    }

    public String toString() {
        return "KeyValueData{ key=" + this.key + ", value=" + this.value + ", timestamp=" + this.timestamp + ", type=" + (Object)((Object)this.type) + " }";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.ccsTimeStamp == null) {
            this.ccsTimeStamp = CCSTimeStamp.currentTimeFromMillis((long)this.timestamp);
        }
    }

    public static enum KeyValueDataType {
        KeyValueTrendingData,
        KeyValuePlotData,
        KeyValueMetaData;

    }
}

