package org.lsst.ccs.subsystem.monitor.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 *********************************************************
 *
 *  Contains a description of the full monitoring state.
 *
 *  Sent on the status bus upon startup or upon request.
 *
 *  @author Owen Saxton
 *
 *********************************************************
 */
@Deprecated
public class MonitorFullState implements Serializable {

    private final List<MonitorChan> channels = new ArrayList<>();     // Monitored channels in id order
    private final Map<String, String> alarms = new LinkedHashMap<>(); // Map of alarm names to descriptions
    private final Map<Integer, String> pages = new LinkedHashMap<>(); // Map of page numbers to names
    private MonitorState monState;   // Current state

    public void addChannel(MonitorChan chan) {
        channels.add(chan);
    }
    
    public List<MonitorChan> getChannels() {
        return channels;
    }
    
    public void addAlarm(String name, String description) {
        alarms.put(name, description);
    }

    public Map<String, String> getAlarms() {
        return alarms;
    }
    
    public void addPage(Integer id, String name) {
        pages.put(id, name);
    }

    public Map<Integer, String> getPages() {
        return pages;
    }
    
    public void setMonitorState(MonitorState state) {
        monState = state;
    }

    public MonitorState getMonitorState() {
        return monState;
    }

    private static final long serialVersionUID = -2881599938903860219L;
}
