/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class ConfigurationParameterInfo
implements Serializable {
    private static final long serialVersionUID = 85957367834684384L;
    private String pathName;
    private String categoryName;
    private String configuredValue;
    private String currentValue;
    private boolean dirty;
    private Boolean isFinal;
    private String componentName;
    private String parameterName;
    private String typeName;
    private transient String description;

    public String getPathName() {
        return this.pathName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getConfiguredValue() {
        return this.configuredValue;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.typeName;
    }

    public boolean isFinal() {
        if (this.isFinal == null) {
            Logger.getLogger((String)"org.lsst.ccs.bus.data").warn((Object)"this version of ConfigurationParameterInfo does not contain the isFinal information. returning false");
            return false;
        }
        return this.isFinal;
    }

    public String toString() {
        return "ConfigurationParameterInfo{pathName=" + this.pathName + ", categoryName=" + this.categoryName + ", configuredValue=" + this.configuredValue + ", currentValue=" + this.currentValue + ", isDirty=" + this.dirty + '}';
    }

    static class Builder {
        private ConfigurationParameterInfo cpi = new ConfigurationParameterInfo();

        Builder() {
        }

        Builder addParameter(ParameterPath path, String type, String category, String description, boolean isFinal) {
            this.cpi.pathName = path.toString();
            this.cpi.componentName = path.getComponentName();
            this.cpi.parameterName = path.getParameterName();
            this.cpi.typeName = type;
            this.cpi.categoryName = category;
            this.cpi.description = description;
            this.cpi.isFinal = isFinal;
            return this;
        }

        Builder updateParameter(String configuredValue, String currentValue, boolean dirty) {
            this.cpi.configuredValue = configuredValue;
            this.cpi.currentValue = currentValue;
            this.cpi.dirty = dirty;
            return this;
        }

        ConfigurationParameterInfo build() {
            return this.cpi;
        }
    }
}

