package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * A dictionary of published data.
 * @author LSST CCS Team
 */
public interface DataProviderDictionary extends Serializable {
    
    /**
     * @return the existing list of DataProviders
     */
    public List<DataProviderInfo> getDataProviderInfos();

    /**
     * @return the existing groups
     */
    public Set<String> getGroups();

    /**
     * @param group
     * @return 
     */
    public List<DataProviderInfo> getDataProviderDescriptionsForGroup(String group);
    
    /**
     * Get the timestamp of the dictionary creation.
     * @return the creation timestamp
     */
    public long getTimestamp();
    
}