/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.BootstrapTestUtils;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.TestApplicationArguments;

public class TestBootstrapResourcesLoading {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");

    @Test
    public void testPropertiesLoading() throws Exception {
        Properties props = BootstrapResourceUtils.getBootstrapProperties((String)"system");
        Assert.assertTrue((!props.getProperty("org.lsst.ccs.workdir").isEmpty() ? 1 : 0) != 0);
        InputStream is = BootstrapResourceUtils.getBootstrapResource((String)"system.properties");
        Properties p = new Properties();
        p.load(is);
        Assert.assertTrue((!p.getProperty("system.property.java.net.preferIPv4Stack").isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((p.getProperty("org.lsst.ccs.workdir") == null ? 1 : 0) != 0);
        Properties props2 = BootstrapResourceUtils.getBootstrapProperties((String)"system", BootstrapResourceUtils.class);
        Assert.assertTrue((!props2.getProperty("org.lsst.ccs.workdir").isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testResourcePath() throws Exception {
        URL systemFileFullURL = BootstrapResourceUtils.getResourceURL((String)"system.properties");
        Assert.assertTrue((systemFileFullURL != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)systemFileFullURL.getPath().endsWith("/system.properties"));
    }

    @Test
    public void testApplicationExtension() throws Exception {
        BootstrapTestUtils.initializeBootstrap(TestBootstrapResourcesLoading.class);
        String test_root = BootstrapTestUtils.getDirectoryForClass(TestApplicationArguments.class);
        String additionalResourceDirectories = test_root + "etc/";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        System.setProperty("org.lsst.ccs.distribution.path", "");
        Bootstrap.setBootstrapApplication((String)"ApplicationExtension");
        Properties p = BootstrapUtils.getApplicationDefinitionProperties((String)"ApplicationExtension");
        Assert.assertEquals((Object)"org.lsst.ccs.bootstrap.Application2MainClass", (Object)p.getProperty("org.lsst.ccs.application.mainClass"));
        Assert.assertEquals((Object)"Application2 Main Class ", (Object)p.getProperty("org.lsst.ccs.application.description"));
        Assert.assertEquals((Object)"thisValue", (Object)p.getProperty("system.property.some.system.property"));
        Bootstrap.setBootstrapApplication(null);
    }

    @Test
    public void testRejectionOfPropertiesWithDuplicateEntries() throws Exception {
        BootstrapTestUtils.initializeBootstrap(TestBootstrapResourcesLoading.class);
        String test_root = BootstrapTestUtils.getDirectoryForClass(TestApplicationArguments.class);
        String additionalResourceDirectories = test_root + "etc/";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        System.setProperty("org.lsst.ccs.distribution.path", "");
        try {
            Properties props = BootstrapResourceUtils.getBootstrapProperties((String)"duplicateEntry");
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

