/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.BootstrapTestUtils;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.ResourceDirectory;
import org.lsst.ccs.bootstrap.ResourcesTree;

public class TestBootstrapResources {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private String test_root;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        BootstrapTestUtils.initializeBootstrap();
        this.test_root = BootstrapTestUtils.getDirectoryForClass(TestBootstrapResources.class);
        String additionalResourceDirectories = this.test_root + "anotherResource/prod" + PATH_SEPARATOR + " " + this.test_root + "someResource/dir/" + PATH_SEPARATOR + this.test_root + "etc";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        System.setProperty("org.lsst.ccs.distribution.path", this.test_root + "other_distribution" + PATH_SEPARATOR + this.test_root);
        ResourcesTree resourcesTree = BootstrapUtils.getBootstrapResourcesTree();
        List dirs = resourcesTree.getResourceDirectoryList();
        Assert.assertTrue((!((ResourceDirectory)dirs.get(0)).isDistributionDir() ? 1 : 0) != 0);
        Assert.assertTrue((!((ResourceDirectory)dirs.get(1)).isDistributionDir() ? 1 : 0) != 0);
        Assert.assertTrue((!((ResourceDirectory)dirs.get(2)).isDistributionDir() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((ResourceDirectory)dirs.get(3)).isDistributionDir());
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testResourceLoading() throws IOException {
        ResourcesTree tree = BootstrapUtils.getBootstrapResourcesTree();
        String additionalResourceDirectories = this.test_root + "anotherResource/prod:" + this.test_root + "someResource/dir/";
        List resources = BootstrapUtils.getOrderedListOfResourceDirectories((String)additionalResourceDirectories, null, (boolean)true);
        tree.clear();
        for (String resource : resources) {
            if (additionalResourceDirectories.contains(resource)) {
                tree.addUserResourceDirectory(resource);
                continue;
            }
            tree.addDistributionResourceDirectory(resource);
        }
        InputStream in = BootstrapResourceUtils.getBootstrapResource((String)"resource.xml");
        Assert.assertNotNull((Object)in);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                Assert.assertTrue((boolean)line.contains("anotherResouce/prod"));
            }
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"/anotherResource.xml");
        Assert.assertNotNull((Object)in);
        reader = new BufferedReader(new InputStreamReader(in));
        var6_6 = null;
        try {
            while ((line = reader.readLine()) != null) {
                Assert.assertTrue((boolean)line.contains("someResource/dir"));
            }
        }
        catch (Throwable line) {
            var6_6 = line;
            throw line;
        }
        finally {
            if (reader != null) {
                if (var6_6 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable line) {
                        var6_6.addSuppressed(line);
                    }
                } else {
                    reader.close();
                }
            }
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"/jarResource.xml");
        Assert.assertNotNull((Object)in);
        reader = new BufferedReader(new InputStreamReader(in));
        var6_6 = null;
        try {
            while ((line = reader.readLine()) != null) {
                Assert.assertTrue((boolean)line.contains("/inJar"));
            }
        }
        catch (Throwable line) {
            var6_6 = line;
            throw line;
        }
        finally {
            if (reader != null) {
                if (var6_6 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable line) {
                        var6_6.addSuppressed(line);
                    }
                } else {
                    reader.close();
                }
            }
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"/org/lsst/ccs/jarResource.xml");
        Assert.assertNotNull((Object)in);
        reader = new BufferedReader(new InputStreamReader(in));
        var6_6 = null;
        try {
            while ((line = reader.readLine()) != null) {
                Assert.assertTrue((boolean)line.contains("/org/lsst/ccs"));
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (var6_6 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
    }

    @Test
    public void testPropertiesPath() throws IOException {
        String nonExistentProperty = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)"nonExistentPropertiesFile");
        Assert.assertTrue((nonExistentProperty == null ? 1 : 0) != 0);
        String pippoProperties = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)"Pippo.properties");
        Assert.assertTrue((pippoProperties != null ? 1 : 0) != 0);
        String randomProperties = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)"random");
        Assert.assertTrue((boolean)randomProperties.equals(this.test_root + "anotherResource/prod/random.properties"));
        String testApp2Properties = BootstrapResourceUtils.getPathOfResourceInUserResourceDirectories((String)"TestApplication2.app");
        Assert.assertTrue((boolean)testApp2Properties.equals(this.test_root + "anotherResource/prod/TestApplication2.app"));
        String testApp3Properties = BootstrapResourceUtils.getPathOfResourceInUserResourceDirectories((String)"TestApplication3.app");
        Assert.assertTrue((boolean)testApp3Properties.equals(this.test_root + "someResource/dir/TestApplication3.app"));
    }

    @Test
    public void testNullResource() throws IOException {
        String additionalResourceDirectories = this.test_root + "anotherResource/prod" + PATH_SEPARATOR + " " + this.test_root + "someResource/dir/" + PATH_SEPARATOR + "../../../../";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        Assert.assertNull((Object)BootstrapResourceUtils.getBootstrapResource((String)"asdfasfa.asdf"));
    }
}

