/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.BootstrapTestUtils;

public class TestApplicationArguments {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");

    @Before
    public void setUp() {
        BootstrapTestUtils.initializeBootstrap(TestApplicationArguments.class);
        String test_root = BootstrapTestUtils.getDirectoryForClass(TestApplicationArguments.class);
        String additionalResourceDirectories = test_root + "anotherResource/prod" + PATH_SEPARATOR + " " + test_root + "someResource/dir/" + PATH_SEPARATOR + " " + test_root + "etc/";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        System.setProperty("org.lsst.ccs.distribution.path", "");
    }

    @Test
    public void testApplicationArguments() throws Exception {
        Properties appProperties = BootstrapResourceUtils.getBootstrapProperties((String)"TestApplicationArguments");
        Bootstrap bootstrap = new Bootstrap(true);
        String[] args = bootstrap.getApplicationArguments(appProperties);
        Assert.assertEquals((long)5L, (long)args.length);
        Assert.assertEquals((Object)"--prompt", (Object)args[0]);
        Assert.assertEquals((Object)"\">> \"", (Object)args[1]);
        Assert.assertEquals((Object)"--dictionaryClasses", (Object)args[2]);
        Assert.assertEquals((Object)"org.lsst.ccs.drivers.eaton.TestEpduG3", (Object)args[3]);
        Assert.assertEquals((Object)"'quoted with spaces'", (Object)args[4]);
    }
}

