/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.resources.ResourcesTreeProperties;
import org.lsst.ccs.bootstrap.resources.ResourcesUtils;

public abstract class BootstrapResourceUtils {
    public static Properties getBootstrapSystemProperties() {
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            System.out.println("*** Getting Bootstrap System Properties");
        }
        return BootstrapResourceUtils.buildBootstrapProperties(null, null, true);
    }

    public static Properties getBootstrapProperties(String fileName, Class clazz) {
        if (clazz == null) {
            clazz = BootstrapResourceUtils.class;
        }
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            System.out.println("*** Looking for Properties " + fileName);
        }
        InputStream in = BootstrapResourceUtils.getResourceFromClassPath(clazz, fileName);
        return BootstrapResourceUtils.buildBootstrapProperties(in, fileName, false);
    }

    public static Properties getBootstrapProperties(String fileName) {
        return BootstrapResourceUtils.getBootstrapProperties(fileName, BootstrapResourceUtils.class);
    }

    public static Properties getBootstrapProperties(String fileName, ClassLoader classLoader) {
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            System.out.println("*** Looking for Properties " + fileName);
        }
        InputStream in = BootstrapResourceUtils.getResourceFromClassPath(classLoader, fileName);
        return BootstrapResourceUtils.buildBootstrapProperties(in, fileName, false);
    }

    private static Properties buildBootstrapProperties(InputStream in, String fileName, boolean includeSystem) {
        ResourcesTreeProperties props = null;
        if (in != null && fileName != null) {
            props = new ResourcesTreeProperties("ClassPath " + fileName, null, null);
            try {
                props.load(in);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Problem loading properties from classpath", ioe);
            }
        }
        String shortName = BootstrapResourceUtils.getShortNameForFileName(fileName);
        String applicationLevel = Bootstrap.getBootstrapApplication();
        String topicLevel = fileName;
        if (BootstrapUtils.getBootstrapListOfApplications().contains(shortName)) {
            applicationLevel = shortName;
            topicLevel = null;
        }
        props = (ResourcesTreeProperties)ResourcesUtils.getMergedProperties(BootstrapUtils.getBootstrapResourcesTree(), new String[]{topicLevel, "ccsGlobal", applicationLevel}, includeSystem, props);
        if (!Bootstrap.getCmdLineProperties().isEmpty()) {
            if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                System.out.println("*** Adding command line properties to properties chain.");
            }
            ResourcesTreeProperties cmdLinePros = new ResourcesTreeProperties("Command Line Properties", null, props);
            cmdLinePros.putAll((Map<?, ?>)Bootstrap.getCmdLineProperties());
            props = cmdLinePros;
        }
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            ResourcesUtils.printProperties(props);
        }
        return props;
    }

    public static InputStream getBootstrapPropertiesInputStream(String fileName, Class clazz) {
        Properties props = BootstrapResourceUtils.getBootstrapProperties(fileName, clazz);
        if (props == null) {
            return null;
        }
        Properties outProps = props;
        if (props instanceof ResourcesTreeProperties) {
            outProps = new Properties();
            ((ResourcesTreeProperties)props).copyProperties(outProps);
        }
        ByteArrayInputStream is = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            outProps.store(output, null);
            is = new ByteArrayInputStream(output.toByteArray());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return is;
    }

    public static InputStream getBootstrapResource(String resourceName, Class clazz) {
        if (clazz == null) {
            clazz = BootstrapResourceUtils.class;
        }
        if (resourceName.endsWith("properties")) {
            throw new RuntimeException("Bootstrap Properties must be fetched with method: getBootstrapProperties");
        }
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            System.out.println("*** Looking for resource " + resourceName + " for Class " + clazz);
        }
        InputStream in = null;
        try {
            in = ResourcesUtils.getResourceFromResourceTree(BootstrapUtils.getBootstrapResourcesTree(), resourceName);
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException(fnfe);
        }
        if (in != null) {
            return in;
        }
        return BootstrapResourceUtils.getResourceFromClassPath(clazz, resourceName);
    }

    public static InputStream getBootstrapResource(String resourceName) {
        return BootstrapResourceUtils.getBootstrapResource(resourceName, BootstrapResourceUtils.class);
    }

    public static InputStream getBootstrapResource(String resourceName, ClassLoader classLoader) {
        if (resourceName.endsWith("properties")) {
            throw new RuntimeException("Bootstrap Properties must be fetched with method: getBootstrapProperties");
        }
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            System.out.println("*** Looking for resource " + resourceName + " for ClassLoader " + classLoader);
        }
        InputStream in = null;
        try {
            in = ResourcesUtils.getResourceFromResourceTree(BootstrapUtils.getBootstrapResourcesTree(), resourceName);
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException(fnfe);
        }
        if (in != null) {
            return in;
        }
        return BootstrapResourceUtils.getResourceFromClassPath(classLoader, resourceName);
    }

    public static Set<Object> getAllKeysInProperties(Properties props) {
        HashSet<Object> keySet = new HashSet<Object>();
        if (props != null) {
            ResourcesUtils.loadKeySetForProperties(props, keySet);
        }
        return keySet;
    }

    private static InputStream getResourceFromClassPath(Class clazz, String resourceName) {
        InputStream in = clazz.getResourceAsStream(resourceName);
        if (in == null && !resourceName.startsWith(BootstrapUtils.FILE_SEPARATOR)) {
            resourceName = String.valueOf(BootstrapUtils.FILE_SEPARATOR) + resourceName;
            in = clazz.getResourceAsStream(resourceName);
        }
        if (Bootstrap.verbose() && in != null && !Bootstrap.isQuiet()) {
            System.out.println("*** Found resource " + resourceName + " in classpath for Class " + clazz);
        }
        return in;
    }

    private static InputStream getResourceFromClassPath(ClassLoader classLoader, String resourceName) {
        InputStream in = classLoader.getResourceAsStream(resourceName);
        if (in == null && !resourceName.startsWith(BootstrapUtils.FILE_SEPARATOR)) {
            resourceName = String.valueOf(BootstrapUtils.FILE_SEPARATOR) + resourceName;
            in = classLoader.getResourceAsStream(resourceName);
        }
        if (Bootstrap.verbose() && in != null && !Bootstrap.isQuiet()) {
            System.out.println("*** Found resource " + resourceName + " in classpath for ClassLoader " + classLoader);
        }
        return in;
    }

    private static String getShortNameForFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        String bootstrapPropertyName = fileName;
        if (fileName.contains(BootstrapUtils.FILE_SEPARATOR)) {
            bootstrapPropertyName = fileName.substring(fileName.lastIndexOf(BootstrapUtils.FILE_SEPARATOR) + 1);
        }
        String shortName = bootstrapPropertyName.replace(".properties", "");
        return shortName;
    }
}

