/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.TestBootstrapDistribution;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.resources.ResourcesTree;

public class TestBootstrapResources {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        Bootstrap.resetBootstrap();
        BootstrapUtils.getCCSDistributionRootDirectory(TestBootstrapDistribution.class);
        ResourcesTree resourcesTree = BootstrapUtils.getBootstrapResourcesTree();
        resourcesTree.clear();
        String test_root = BootstrapUtils.getCCSDistributionRootDirectory();
        String additionalResourceDirectories = String.valueOf(test_root) + "anotherResource/prod:" + test_root + "someResource/dir/";
        String testDistributionDirectoryEnvVariable = " other_distribution";
        List resources = BootstrapUtils.getOrderedListOfResourceDirectories((String)additionalResourceDirectories, (String)testDistributionDirectoryEnvVariable, (boolean)true);
        for (String resource : resources) {
            resourcesTree.addResourceDirectory(resource);
        }
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testResourceLoading() throws IOException {
        String line;
        BufferedReader reader;
        ResourcesTree tree = BootstrapUtils.getBootstrapResourcesTree();
        String test_root = BootstrapUtils.getCCSDistributionRootDirectory();
        String additionalResourceDirectories = String.valueOf(test_root) + "anotherResource/prod:" + test_root + "someResource/dir/";
        List resources = BootstrapUtils.getOrderedListOfResourceDirectories((String)additionalResourceDirectories, null, (boolean)true);
        tree.clear();
        for (String resource : resources) {
            tree.addResourceDirectory(resource);
        }
        InputStream in = BootstrapResourceUtils.getBootstrapResource((String)"/org/lsst/ccs/resource.xml");
        Assert.assertNotNull((Object)in);
        Object object = null;
        Object var7_11 = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            try {
                while ((line = reader.readLine()) != null) {
                    Assert.assertTrue((boolean)line.contains("anotherResouce/prod"));
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"/anotherResource.xml");
        Assert.assertNotNull((Object)in);
        object = null;
        var7_11 = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            try {
                while ((line = reader.readLine()) != null) {
                    Assert.assertTrue((boolean)line.contains("someResource/dir"));
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"/jarResource.xml");
        Assert.assertNotNull((Object)in);
        object = null;
        var7_11 = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            try {
                while ((line = reader.readLine()) != null) {
                    Assert.assertTrue((boolean)line.contains("/inJar"));
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"/org/lsst/ccs/jarResource.xml");
        Assert.assertNotNull((Object)in);
        object = null;
        var7_11 = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            try {
                while ((line = reader.readLine()) != null) {
                    Assert.assertTrue((boolean)line.contains("/org/lsst/ccs"));
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }
}

