package org.lsst.ccs.bootstrap.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 * @author turri
 */
public class SystemPropertyMatcher {

    private static final Pattern systemPropertiesPattern = Pattern.compile("-D([^=:]*)([=:]?)([^=:]*)");
    private Matcher m;

    public SystemPropertyMatcher(String str) {
        m = systemPropertiesPattern.matcher(str);        
    }
    
    public boolean matches() {
        return m.matches();
    }
    
    public String getProperty() {
        return m.group(1);
    }
    
    public String getValue() {
        return m.group(3);
    }
    
    public String getSeparator() {
        return m.group(2);
    }
    
    public static SystemPropertyMatcher matcher(String str) {
        return new SystemPropertyMatcher(str);
    }
}
