/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd.image.data;

import java.nio.ByteBuffer;

public class RawImageData {
    private final BitsPerPixel sample;
    private final ByteBuffer data;

    public RawImageData(BitsPerPixel sample, ByteBuffer data) {
        this.sample = sample;
        this.data = data;
    }

    public BitsPerPixel getSample() {
        return this.sample;
    }

    public ByteBuffer getImageData() {
        return this.data;
    }

    public static enum BitsPerPixel {
        BIT16(2),
        BIT32(4);

        private final int bytes;

        private BitsPerPixel(int bytes) {
            this.bytes = bytes;
        }

        public int bytes() {
            return this.bytes;
        }

        public int bits() {
            return 8 * this.bytes;
        }
    }
}

