/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.compiler;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilderVisitor;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Sequencer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SequencerTextParser;
import org.xml.sax.SAXException;

public class FPGA2ModelBuilder {
    public FPGA2Model compileFile(InputStream inputStream) throws IOException {
        return this.compileFile(inputStream, null);
    }

    public FPGA2Model compileFile(InputStream inputStream, BigDecimal clockPeriodOverride) throws IOException {
        Sequencer s;
        if (inputStream == null) {
            throw new IOException("Input stream is null");
        }
        BufferedInputStream in = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        in.mark(1);
        boolean isXml = in.read() == 60;
        in.reset();
        if (isXml) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Sequencer.class});
                Unmarshaller u = context.createUnmarshaller();
                try (InputStream si = Sequencer.class.getResourceAsStream("schema.xsd");){
                    SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    Schema schema = sf.newSchema(new StreamSource(si));
                    u.setSchema(schema);
                }
                s = (Sequencer)u.unmarshal((InputStream)in);
            }
            catch (JAXBException e) {
                throw new RuntimeException("error reading XML file", e);
            }
            catch (SAXException e) {
                throw new RuntimeException("error validating XML file", e);
            }
        }
        s = SequencerTextParser.parse(new InputStreamReader(in));
        FPGA2ModelBuilderVisitor visitor = new FPGA2ModelBuilderVisitor(clockPeriodOverride);
        visitor.visit(s);
        s.validate();
        visitor.getModel().validate();
        return visitor.getModel();
    }

    public FPGA2Model compileFile(File srcFile) throws IOException {
        try (FileInputStream in = new FileInputStream(srcFile);){
            FPGA2Model fPGA2Model = this.compileFile(in);
            return fPGA2Model;
        }
    }
}

