/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.common;

import java.util.EnumSet;
import java.util.Set;

public enum PLCError {
    MOTION_VETO(0, "Hardware protection logic veto is in effect, can't move."),
    BRAKE_SET(1, "Axis brake is set, can't move."),
    HALL_DIFF(2, "Hall transition position too far from the expected."),
    SHORT_EXPOSURE(3, "Exposure time too short."),
    NOT_HOMED(4, "Axis is not homed."),
    HOME_LIMIT(5, "Hit motion limit near axis home position."),
    DEPLOYED_LIMIT(6, "Hit motion limit near axis deployed position."),
    UNSAFE_MOVE(7, "Command rejected, collision danger."),
    TOO_FAST(8, "Can't move that fast."),
    AXIS_DISABLED(9, "Axis is disabled, can't move.");

    private final int bitnum;
    private final String description;

    private PLCError(int bitnum, String description) {
        this.bitnum = bitnum;
        this.description = description;
    }

    public int getBitnum() {
        return this.bitnum;
    }

    public String getDescription() {
        return this.description;
    }

    public static Set<PLCError> decodeMask(int mask) {
        EnumSet<PLCError> errors = EnumSet.noneOf(PLCError.class);
        for (PLCError err : PLCError.values()) {
            if ((mask & 1 << err.getBitnum()) == 0) continue;
            errors.add(err);
        }
        return errors;
    }

    public static int encodeMask(Set<PLCError> errors) {
        int mask = 0;
        for (PLCError err : errors) {
            mask |= 1 << err.getBitnum();
        }
        return mask;
    }

    public static Set<PLCError> copyOf(Set<PLCError> errors) {
        return errors.isEmpty() ? EnumSet.noneOf(PLCError.class) : EnumSet.copyOf(errors);
    }
}

