/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.subsystem.common.actions.BulkPsPowerAction;
import org.lsst.ccs.subsystem.power.RebPsDevice;
import org.lsst.ccs.subsystem.power.alerts.RebPowerAlertType;

public class RebPsBoardAlarm
extends Alarm {
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    RebPsDevice rebPsDevice;
    RebPowerAlertType alertType = null;

    public void build() {
        if (this.rebPsDevice == null) {
            throw new RuntimeException("A RebPowerAlertType must defined within a RebPsDevice.");
        }
        if (this.alertType == null) {
            throw new RuntimeException("An alert type must be specified.");
        }
        super.build();
        this.description = this.alertType.getDescription();
    }

    RebPsDevice getRebDevice() {
        return this.rebPsDevice;
    }

    public Alert getAlert(AlertState alertState, AlertState previousAlertState) {
        Alert alert = new Alert(this.alertType.getAlertId() + "/" + this.rebPsDevice.getPath(), this.alertType.getDescription());
        if (this.alertType == RebPowerAlertType.REB_PS_BOARD_TEMPERATURE_TOO_HIGH && alertState == AlertState.ALARM) {
            BulkPsPowerAction.addBulkPsPowerActionPayloadToAlert((Alert)alert, (BulkPsPowerAction.Type)BulkPsPowerAction.Type.TURN_BULK_PS_OFF, (String)this.rebPsDevice.getBulkPsSwitchName());
        }
        return alert;
    }
}

