/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.subsystem.comcam.filterchanger.data.EndSetFilterData;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSSetFilterEvent;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChangerInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.states.FcsPowerState;
import org.lsst.ccs.subsystem.ocsbridge.states.FilterState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class FilterChangerSimulation
implements FilterChangerInterface {
    private static final Logger LOG = Logger.getLogger(FilterChangerSimulation.class.getName());
    private static final Map<String, FilterChangerInterface.FilterType> mainCameraFilters = new LinkedHashMap<String, FilterChangerInterface.FilterType>();
    private static final List<String> mainCameraInstalledFilters;
    private static final Map<String, FilterChangerInterface.FilterType> comCamFilters;
    private static final List<String> comCamInstalledFilters;
    static final Duration LOAD_TIME;
    static final Duration ROTATION_TIME_PER_DEGREE;
    static final Duration UNLOAD_TIME;
    private final Map<String, FilterChangerInterface.FilterType> allFilters;
    private final List<String> installedFilters;
    private final MCMConfig config;
    private String currentFilter;
    private int currentRotationPosition = 0;
    private final CCS ccs;
    private final State<FilterState> filterState;
    private final State<FcsPowerState> powerState;
    private boolean powerSaveAllowed = true;
    private volatile KeyValueDataList lastPublishedFCStateData = null;
    private final Object lastPublishedFCStateDataLock = new Object();
    private Agent agent;
    private final Random random = new Random();

    FilterChangerSimulation(CCS ccs, MCMConfig config) {
        this.ccs = ccs;
        this.config = config;
        switch (config.getCameraType()) {
            case MAIN_CAMERA: {
                this.allFilters = mainCameraFilters;
                this.installedFilters = mainCameraInstalledFilters;
                this.currentFilter = mainCameraInstalledFilters.get(0);
                break;
            }
            case COMCAM: {
                this.allFilters = comCamFilters;
                this.installedFilters = comCamInstalledFilters;
                this.currentFilter = comCamInstalledFilters.get(0);
                break;
            }
            default: {
                throw new RuntimeException("Filter changer not supported for " + config.getCameraType());
            }
        }
        this.filterState = new State<FilterState>(FilterState.LOADED);
        this.powerState = new State<FcsPowerState>(FcsPowerState.LOW_POWER);
        ccs.getAggregateStatus().add(CCSTimeStamp.currentTime(), this.filterState);
        ccs.getAggregateStatus().add(CCSTimeStamp.currentTime(), this.powerState);
    }

    @Override
    public List<String> getAvailableFilters() {
        return Collections.unmodifiableList(this.installedFilters);
    }

    @Override
    public List<String> getInstalledFilters() {
        return Collections.unmodifiableList(this.installedFilters);
    }

    @Override
    public String getFilterType(String filterName) {
        return this.allFilters.get(filterName).getName();
    }

    @Override
    public void start(String configName) {
    }

    @Override
    public String getCurrentFilter() {
        return this.currentFilter;
    }

    @Override
    public void setFilter(String filterName) {
        try {
            int targetRotation = -1;
            int position = this.getInstalledFilters().indexOf(filterName);
            if (position < 0) {
                throw new IllegalArgumentException("Invalid or uninstalled filter: " + filterName);
            }
            if (filterName.equals(this.currentFilter)) {
                return;
            }
            if (this.config.getCameraType().equals((Object)Camera.MAIN_CAMERA) && this.powerState.isInState(FcsPowerState.LOW_POWER)) {
                this.wakeFilterChanger(1);
            }
            FilterChangerInterface.FilterType requestedFilterType = this.allFilters.get(filterName);
            FilterChangerInterface.FilterType currentFilterType = this.allFilters.get(this.currentFilter);
            this.ccs.fireEvent(new CCSSetFilterEvent(filterName, requestedFilterType.getName()));
            if (!currentFilterType.equals((Object)FilterChangerInterface.FilterType.NONE)) {
                this.filterState.setState(FilterState.UNLOADING);
                CompletableFuture<Void> waitForUnloaded = this.ccs.waitForStatus(FilterState.UNLOADED);
                this.ccs.schedule(UNLOAD_TIME, () -> {
                    this.filterState.setState(FilterState.UNLOADED);
                    this.currentFilter = filterName;
                });
                waitForUnloaded.get(UNLOAD_TIME.toMillis() * 2L, TimeUnit.MILLISECONDS);
            }
            if (!requestedFilterType.equals((Object)FilterChangerInterface.FilterType.NONE)) {
                targetRotation = (position + 1) * 360 / 5;
                if (this.currentRotationPosition != targetRotation) {
                    int randomSockets = this.getRandomRelativeCarouselSocket();
                    int degreesToRotate = Math.abs(this.currentRotationPosition - randomSockets * targetRotation) % 360;
                    this.filterState.setState(FilterState.ROTATING);
                    CompletableFuture<Void> waitForRotation = this.ccs.waitForStatus(FilterState.UNLOADED);
                    Duration rotationTime = ROTATION_TIME_PER_DEGREE.multipliedBy(degreesToRotate);
                    this.ccs.schedule(rotationTime, () -> this.filterState.setState(FilterState.UNLOADED));
                    waitForRotation.get(rotationTime.toMillis() * 2L, TimeUnit.MILLISECONDS);
                    this.currentRotationPosition = targetRotation;
                }
                this.filterState.setState(FilterState.LOADING);
                CompletableFuture<Void> waitForLoaded = this.ccs.waitForStatus(FilterState.LOADED);
                this.ccs.schedule(LOAD_TIME, () -> {
                    this.filterState.setState(FilterState.LOADED);
                    this.currentFilter = filterName;
                });
                waitForLoaded.get(LOAD_TIME.toMillis() * 2L, TimeUnit.MILLISECONDS);
            }
            if (this.config.getCameraType().equals((Object)Camera.COMCAM)) {
                String fname = this.getCurrentFilter();
                String ftype = this.getFilterType(fname);
                int fslot = 1;
                int fpos = this.getInstalledFilters().indexOf(fname);
                EndSetFilterData data = new EndSetFilterData(fname, ftype, fslot, (double)fpos);
                KeyValueDataList kvd = new KeyValueDataList();
                kvd.addData("endSetFilter", (Serializable)data);
                this.publishCurrentFCState(kvd);
            }
            this.ccs.fireEvent(new CCSSetFilterEvent(filterName, requestedFilterType.getName(), position, targetRotation));
            if (this.config.getCameraType().equals((Object)Camera.MAIN_CAMERA) && this.powerSaveAllowed) {
                this.wakeFilterChanger(0);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw new RuntimeException("Error while changing filter", ex);
        }
    }

    private int getRandomRelativeCarouselSocket() {
        int randomStep;
        while ((randomStep = this.random.nextInt(5) - 2) == 0) {
        }
        return randomStep;
    }

    @Override
    public Duration getDurationForFastFilterChange(String filterName) {
        return ROTATION_TIME_PER_DEGREE.multipliedBy(360L).plus(LOAD_TIME).plus(UNLOAD_TIME);
    }

    @Override
    public void wakeFilterChanger(int mode) throws ExecutionException {
        Duration timeout = this.getDurationForWakeUp(mode);
        this.powerSaveAllowed = mode != 2;
        switch (mode) {
            case 0: {
                try {
                    if (!this.powerState.isInState(FcsPowerState.REGULAR)) break;
                    CompletableFuture<Void> waitForTimeout = this.ccs.waitForStatus(FcsPowerState.LOW_POWER);
                    this.ccs.schedule(timeout, () -> this.powerState.setState(FcsPowerState.LOW_POWER));
                    waitForTimeout.get(timeout.toMillis() * 2L, TimeUnit.MILLISECONDS);
                    break;
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    throw new ExecutionException("Error while FES going to sleep", ex);
                }
            }
            case 1: 
            case 2: {
                try {
                    if (!this.powerState.isInState(FcsPowerState.LOW_POWER)) break;
                    CompletableFuture<Void> waitForTimeout = this.ccs.waitForStatus(FcsPowerState.REGULAR);
                    this.ccs.schedule(timeout, () -> this.powerState.setState(FcsPowerState.REGULAR));
                    waitForTimeout.get(timeout.toMillis() * 2L, TimeUnit.MILLISECONDS);
                    break;
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    throw new ExecutionException("Error while FES waking up", ex);
                }
            }
            default: {
                throw new RuntimeException("Unsupported wake up mode");
            }
        }
    }

    @Override
    public Duration getDurationForWakeUp(int mode) {
        return switch (mode) {
            case 0 -> Duration.ofMillis(2000L);
            case 1, 2 -> Duration.ofMillis(4000L);
            default -> throw new RuntimeException("Unsupported wake up mode");
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishCurrentFCState(KeyValueDataList kvd) {
        Object object = this.lastPublishedFCStateDataLock;
        synchronized (object) {
            if (kvd != null) {
                this.lastPublishedFCStateData = kvd;
            }
            LOG.log(Level.FINE, "Publishing current FCS State: " + this.lastPublishedFCStateData);
            if (this.lastPublishedFCStateData != null && this.agent != null) {
                this.agent.publishSubsystemDataOnStatusBus((KeyValueData)this.lastPublishedFCStateData);
            }
        }
    }

    void setTopLevelAgent(Agent agent) {
        this.agent = agent;
    }

    void publishDataProviderCurrentData() {
        this.publishCurrentFCState(null);
    }

    static {
        mainCameraFilters.put("u_24", FilterChangerInterface.FilterType.U);
        mainCameraFilters.put("g_6", FilterChangerInterface.FilterType.G);
        mainCameraFilters.put("r_57", FilterChangerInterface.FilterType.R);
        mainCameraFilters.put("i_39", FilterChangerInterface.FilterType.I);
        mainCameraFilters.put("z_20", FilterChangerInterface.FilterType.Z);
        mainCameraFilters.put("y_10", FilterChangerInterface.FilterType.Y);
        mainCameraFilters.put("ef_43", FilterChangerInterface.FilterType.EF);
        mainCameraFilters.put("ph_5", FilterChangerInterface.FilterType.PH);
        mainCameraFilters.put("NONE", FilterChangerInterface.FilterType.NONE);
        mainCameraInstalledFilters = new ArrayList<String>();
        mainCameraInstalledFilters.add("u_24");
        mainCameraInstalledFilters.add("g_6");
        mainCameraInstalledFilters.add("r_57");
        mainCameraInstalledFilters.add("i_39");
        mainCameraInstalledFilters.add("z_20");
        mainCameraInstalledFilters.add("NONE");
        comCamFilters = new LinkedHashMap<String, FilterChangerInterface.FilterType>();
        comCamFilters.put("u_05", FilterChangerInterface.FilterType.U);
        comCamFilters.put("g_07", FilterChangerInterface.FilterType.G);
        comCamFilters.put("g_01", FilterChangerInterface.FilterType.G);
        comCamFilters.put("r_03", FilterChangerInterface.FilterType.R);
        comCamFilters.put("i_06", FilterChangerInterface.FilterType.I);
        comCamFilters.put("z_03", FilterChangerInterface.FilterType.Z);
        comCamFilters.put("z_02", FilterChangerInterface.FilterType.Z);
        comCamFilters.put("y_04", FilterChangerInterface.FilterType.Y);
        comCamFilters.put("pinhole", FilterChangerInterface.FilterType.OTHER);
        comCamFilters.put("NONE", FilterChangerInterface.FilterType.NONE);
        comCamInstalledFilters = new ArrayList<String>();
        comCamInstalledFilters.add("i_06");
        comCamInstalledFilters.add("r_03");
        comCamInstalledFilters.add("g_07");
        LOAD_TIME = Duration.ofMillis(15000L);
        ROTATION_TIME_PER_DEGREE = Duration.ofMillis(100L);
        UNLOAD_TIME = Duration.ofMillis(15000L);
    }
}

