/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.kafka.avro;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class Topic {
    private final String name;
    private final Map<String, Set<String>> tagValuesMap = new LinkedHashMap<String, Set<String>>();
    private final Set<TopicField> fields = new LinkedHashSet<TopicField>();
    private int maxLength = 0;
    private final String namespace;

    public Topic(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
        this.addField("timestamp", "long", "UTC timestamp", "millisecond");
    }

    void addTag(String tagName, String value) {
        this.tagValuesMap.computeIfAbsent(tagName, t -> new TreeSet()).add(value);
    }

    void addTags(Map<String, String> tags) {
        for (Map.Entry<String, String> e : tags.entrySet()) {
            this.addTag(e.getKey(), e.getValue());
        }
    }

    final TopicField addField(String name, String type, String description, String units) {
        if (name.length() > this.maxLength) {
            this.maxLength = name.length();
        }
        TopicField field = new TopicField(name, type, description, units, this);
        this.fields.add(field);
        return field;
    }

    public String getName() {
        return this.name;
    }

    public String getNameSpace() {
        return this.namespace;
    }

    public String getFullName() {
        return this.namespace + "." + this.name;
    }

    public Set<TopicField> getFields() {
        return new LinkedHashSet<TopicField>(this.fields);
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(this.tagValuesMap.keySet());
    }

    public Set<String> getTagValues(String tag) {
        return new LinkedHashSet<String>((Collection)this.tagValuesMap.get(tag));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Topic: ").append(this.namespace).append(".").append(this.name).append("\n");
        sb.append("Fields:\n");
        for (TopicField field : this.fields) {
            sb.append("   ").append(field.getName());
            for (int i = field.getName().length(); i < this.maxLength + 4; ++i) {
                sb.append(" ");
            }
            sb.append(field.getType()).append("\n");
        }
        LinkedHashMap<String, Set<String>> tmpTagValuesMap = new LinkedHashMap<String, Set<String>>();
        tmpTagValuesMap.putAll(this.tagValuesMap);
        if (tmpTagValuesMap.containsKey("agent") && ((Set)tmpTagValuesMap.get("agent")).size() <= 1) {
            tmpTagValuesMap.remove("agent");
        }
        if (!tmpTagValuesMap.isEmpty()) {
            sb.append("Tags:\n");
            for (Map.Entry e : tmpTagValuesMap.entrySet()) {
                sb.append("  ").append((String)e.getKey()).append(" ").append(e.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    public static class TopicField {
        private final String name;
        private final String type;
        private final String description;
        private final String units;
        private final Topic topic;

        TopicField(String name, String type, String description, String units, Topic topic) {
            this.name = name;
            this.type = type;
            this.description = description;
            this.units = units;
            this.topic = topic;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUnits() {
            return this.units;
        }

        public Topic getTopic() {
            return this.topic;
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + Objects.hashCode(this.name);
            hash = 71 * hash + Objects.hashCode(this.type);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TopicField other = (TopicField)obj;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return Objects.equals(this.type, other.type);
        }
    }
}

