/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.efd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.ws.rs.Path;
import org.hibernate.Session;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.efd.EfdQueryBuilder;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.server.DataServer;

@Path(value="/dataserver")
@Singleton
public class EfdDataServer
extends DataServer {
    private InfluxDB influxDb;
    private String namespace;
    private static final Logger LOG = Logger.getLogger(EfdDataServer.class.getName());

    public EfdDataServer() {
        LOG.info("Created EFD Rest Server");
        this.getInfluxDb();
    }

    @Override
    public List<StatDesc> getAvailableStats(long rawId, Session sess) {
        return Collections.EMPTY_LIST;
    }

    private InfluxDB getInfluxDb() {
        if (this.influxDb == null) {
            String credentialsFile = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.efd.database.connection.file", "efdCredentials.properties");
            Properties credentialsProperties = BootstrapResourceUtils.getBootstrapProperties((String)credentialsFile);
            String username = credentialsProperties.getProperty("org.lsst.ccs.efd.username", "");
            String password = credentialsProperties.getProperty("org.lsst.ccs.efd.password", "");
            String url = credentialsProperties.getProperty("org.lsst.ccs.efd.url", "");
            this.namespace = credentialsProperties.getProperty("org.lsst.ccs.efd.namespace", "");
            if (username.isEmpty() || password.isEmpty() || url.isEmpty() || this.namespace.isEmpty()) {
                throw new RuntimeException("The following properties must be specified in file " + credentialsFile + ": \norg.lsst.ccs.efd.username\norg.lsst.ccs.efd.password\norg.lsst.ccs.efd.url\norg.lsst.ccs.efd.napespace");
            }
            this.influxDb = InfluxDBFactory.connect((String)url, (String)username, (String)password);
        }
        return this.influxDb;
    }

    @Override
    public List<RawData> getRawData(String path, long t1, long t2, Session sess) {
        EfdQueryBuilder queryBuilder = new EfdQueryBuilder(this.namespace);
        Query query = (queryBuilder = queryBuilder.forPath(path).withTimeRange(t1, t2)).buildQuery();
        QueryResult queryResult = this.influxDb.query(query, TimeUnit.MILLISECONDS);
        if (queryResult.getResults().size() > 1) {
            throw new RuntimeException("Got more results than expected: " + queryResult.getResults().size() + " for query " + query.getCommand());
        }
        List<RawData> dataList = null;
        for (QueryResult.Result r : queryResult.getResults()) {
            if (r.getSeries().size() > 1) {
                throw new RuntimeException("Got more series than expected: " + r.getSeries().size() + " for query " + query.getCommand());
            }
            for (QueryResult.Series s : r.getSeries()) {
                for (String column : s.getColumns()) {
                    if (column.equals("time")) continue;
                    dataList = EfdDataServer.convertSeriesToRawData(s, column);
                }
            }
        }
        return dataList;
    }

    @Override
    protected List<DataServer.StatEntry> getStatDataFromRaw(String path, long t1, long t2, int nsamples, Session sess) {
        EfdQueryBuilder queryBuilder = new EfdQueryBuilder(this.namespace);
        Query query = (queryBuilder = queryBuilder.forPath(path).withTimeRange(t1, t2).withSamples(nsamples)).buildQuery();
        QueryResult queryResult = this.influxDb.query(query, TimeUnit.MILLISECONDS);
        if (queryResult.getResults().size() > 1) {
            throw new RuntimeException("Got more results than expected: " + queryResult.getResults().size() + " for query " + query.getCommand());
        }
        List<DataServer.StatEntry> dataList = null;
        for (QueryResult.Result r : queryResult.getResults()) {
            if (r.getSeries().size() > 1) {
                throw new RuntimeException("Got more series than expected: " + r.getSeries().size() + " for query " + query.getCommand());
            }
            for (QueryResult.Series s : r.getSeries()) {
                for (String column : s.getColumns()) {
                    dataList = EfdDataServer.convertSeriesToStatData(s, queryBuilder.getTimeWidth());
                }
            }
        }
        return dataList;
    }

    @Override
    public List<StatData> getStatData(StatDesc statDesc, long t1, long t2, Session sess) {
        throw new UnsupportedOperationException("Stat data queries are not supported for the EFD Database");
    }

    public static List<RawData> convertSeriesToRawData(QueryResult.Series series, String column) {
        ArrayList<RawData> r = new ArrayList<RawData>();
        int timeIndex = series.getColumns().indexOf("time");
        int dataIndex = series.getColumns().indexOf(column);
        for (List dataList : series.getValues()) {
            Object time = dataList.get(timeIndex);
            Object data = dataList.get(dataIndex);
            if (data == null) continue;
            RawData rawData = new RawData();
            rawData.setTime(((Double)time).longValue());
            rawData.setDoubleData((double)((Double)data));
            r.add(rawData);
        }
        return r;
    }

    public static List<DataServer.StatEntry> convertSeriesToStatData(QueryResult.Series series, long timeWidth) {
        ArrayList<DataServer.StatEntry> r = new ArrayList<DataServer.StatEntry>();
        int timeIndex = series.getColumns().indexOf("time");
        int maxValueIndex = series.getColumns().indexOf("maxValue");
        int minValueIndex = series.getColumns().indexOf("minValue");
        int meanValueIndex = series.getColumns().indexOf("meanValue");
        int stddevValueIndex = series.getColumns().indexOf("stddevValue");
        for (List dataList : series.getValues()) {
            Object meanValue;
            Object minValue;
            Object time = dataList.get(timeIndex);
            Object maxValue = dataList.get(maxValueIndex);
            if (maxValue == null || (minValue = dataList.get(minValueIndex)) == null || (meanValue = dataList.get(meanValueIndex)) == null) continue;
            Object stddevValue = dataList.get(stddevValueIndex);
            double stddev = 0.0;
            if (stddevValue != null) {
                stddev = (Double)stddevValue;
            }
            long minTime = ((Double)time).longValue();
            long maxTime = minTime + timeWidth;
            DataServer.StatEntry statEntry = new DataServer.StatEntry(minTime, maxTime, (Double)meanValue, stddev, (Double)minValue, (Double)maxValue);
            r.add(statEntry);
        }
        return r;
    }

    public static void main(String[] args) throws Exception {
        String additionalResourceDirectories = "~/ccs/etc";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        EfdDataServer dataServer = new EfdDataServer();
        InfluxDB influxDb = dataServer.getInfluxDb();
        Pong p = influxDb.ping();
        System.out.println(p);
        try {
            EfdQueryBuilder queryBuilder = new EfdQueryBuilder("lsst.MTCamera");
            queryBuilder = queryBuilder.forPath("chiller1/Chiller/TempStage2Evap").withTimeRange(1743005901693L, 1743006501693L).withSamples(100);
            Query query = queryBuilder.buildQuery();
            System.out.println(query.getCommand() + " " + query.getDatabase());
            QueryResult queryResult = influxDb.query(query, TimeUnit.MILLISECONDS);
            for (QueryResult.Result r : queryResult.getResults()) {
                for (QueryResult.Series s : r.getSeries()) {
                    System.out.println("**** " + s.toString().replaceAll("], ", "]\n").replaceAll("values=", "").replace("[", "").replace("]", ""));
                    if (queryBuilder.isRawData()) {
                        for (String column : s.getColumns()) {
                            if (column.equals("time")) continue;
                            List<RawData> data = EfdDataServer.convertSeriesToRawData(s, column);
                            System.out.println(data);
                        }
                        continue;
                    }
                    List<DataServer.StatEntry> dataList = EfdDataServer.convertSeriesToStatData(s, queryBuilder.getTimeWidth());
                    System.out.println("Got " + dataList.size() + " statistical entries");
                    System.out.println(dataList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            influxDb.close();
            System.exit(0);
        }
    }
}

