/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientResponseContext;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskCache;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.lsst.ccs.rest.file.server.client.RestFileSystemOptions;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileSystemOptionsHelper;

class Cache
implements Closeable {
    private CacheAccess<URI, CacheEntry> map;
    private FileLock lock;
    private RestFileSystemOptions.CacheFallback cacheFallback;

    Cache(RestFileSystemOptionsHelper options) throws IOException {
        JCS.setLogSystem((String)"jul");
        if (!options.isCacheLogging()) {
            Logger logger = Logger.getLogger("org.apache.commons.jcs3");
            logger.setLevel(Level.WARNING);
        }
        Properties props = new Properties();
        try (InputStream in = Cache.class.getResourceAsStream("memory.ccf");){
            props.load(in);
        }
        if (options.getCacheOptions() == RestFileSystemOptions.CacheOptions.MEMORY_AND_DISK) {
            in = Cache.class.getResourceAsStream("disk.ccf");
            try {
                props.load(in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            Path cacheLocation = options.getDiskCacheLocation();
            if (cacheLocation != null) {
                for (int n = 1; n < 100; ++n) {
                    block24: {
                        Files.createDirectories(cacheLocation, new FileAttribute[0]);
                        if (Files.isDirectory(cacheLocation, new LinkOption[0]) || Files.isWritable(cacheLocation)) {
                            Path lockFile = cacheLocation.resolve("lockFile");
                            FileChannel lockFileChannel = FileChannel.open(lockFile, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                            try {
                                this.lock = lockFileChannel.tryLock();
                                if (this.lock != null) break;
                                if (!options.allowAlternateCacheLoction()) {
                                    throw new IOException("Cache already in use");
                                }
                                break block24;
                            }
                            catch (OverlappingFileLockException x) {
                                if (!options.allowAlternateCacheLoction()) {
                                    throw new IOException("Cache already in use", x);
                                }
                                break block24;
                            }
                        }
                        throw new IOException("Invalid cache location: " + cacheLocation);
                    }
                    cacheLocation = cacheLocation.resolveSibling(cacheLocation.getFileName() + "-" + n);
                }
                if (this.lock == null) {
                    throw new IOException("Cache already in use and unable to get alternate cache location");
                }
                props.setProperty("jcs.auxiliary.DC.attributes.DiskPath", cacheLocation.toAbsolutePath().toString());
            }
        }
        CompositeCacheManager ccm = CompositeCacheManager.getUnconfiguredInstance();
        ccm.configure(props);
        this.map = JCS.getInstance((String)"default");
        this.cacheFallback = options.getCacheFallback();
    }

    void setCacheFallbackOption(RestFileSystemOptions.CacheFallback cacheFallback) {
        this.cacheFallback = cacheFallback;
    }

    boolean doEntriesExpire() {
        return this.cacheFallback != RestFileSystemOptions.CacheFallback.WHEN_POSSIBLE;
    }

    CacheEntry getEntry(URI uri) {
        CacheEntry e = (CacheEntry)this.map.get((Object)uri);
        if (e != null) {
            e.setIsExpired(this.doEntriesExpire());
        }
        return e;
    }

    void cacheResponse(ClientResponseContext response, URI uri) throws IOException {
        this.map.put((Object)uri, (Object)new CacheEntry(response));
    }

    @Override
    public void close() throws IOException {
        Logger logger = Logger.getLogger(IndexedDiskCache.class.getName());
        logger.setLevel(Level.OFF);
        if (this.lock != null) {
            this.lock.close();
            this.lock.channel().close();
            this.lock = null;
        }
    }

    public static class CacheEntry
    implements Serializable {
        private String tag;
        private Date lastModified;
        private String mediaType;
        private byte[] bytes;
        private volatile int updateCount = 0;
        private boolean isExpired = true;
        static final long serialVersionUID = 1521062449875932852L;

        public CacheEntry() {
        }

        private CacheEntry(ClientResponseContext response) throws IOException {
            int l;
            this.tag = response.getEntityTag() == null ? null : response.getEntityTag().toString();
            this.lastModified = response.getLastModified();
            this.mediaType = response.getMediaType().toString();
            InputStream in = response.getEntityStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[8096];
            while ((l = in.read(buffer)) >= 0) {
                out.write(buffer, 0, l);
            }
            out.close();
            this.bytes = out.toByteArray();
            response.setEntityStream(new ByteArrayInputStream(this.bytes));
        }

        boolean isExpired() {
            return this.isExpired;
        }

        void setIsExpired(boolean isExpired) {
            this.isExpired = isExpired;
        }

        byte[] getContent() {
            return this.bytes;
        }

        String getContentType() {
            return this.mediaType;
        }

        String getETagHeader() {
            return this.tag;
        }

        Date getLastModified() {
            return this.lastModified;
        }

        void updateCacheHeaders(ClientResponseContext response) {
            this.tag = response.getEntityTag() == null ? null : response.getEntityTag().toString();
            this.lastModified = response.getLastModified();
            ++this.updateCount;
        }

        int getUpdateCount() {
            return this.updateCount;
        }
    }
}

