/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;

public class StatusDataPublishedByAutochangerTwoTrucks
implements Serializable {
    private static final long serialVersionUID = 8770787257648489652L;
    @DataAttributes(description="Position of autochanger driver truck along linear rails", units="micron")
    private int driverPosition = 0;
    @DataAttributes(description="Position of autochanger follower truck along linear rails", units="micron")
    private int followerPosition = 0;
    @DataAttributes(description="Difference of position between autochanger driver and follower trucks along linear rails", units="micron")
    private int deltaDriverFollowerPosition = 0;
    @DataAttributes(description="Homing on both autochanger truck controllers is done", units="unitless")
    private boolean homingDone = false;
    @DataAttributes(description="Both autochanger trucks are at handoff position", units="unitless")
    private boolean atHandoff = false;
    @DataAttributes(description="Both autochanger trucks are at online position", units="unitless")
    private boolean atOnline = false;
    @DataAttributes(description="Both autochanger trucks are at standby position", units="unitless")
    private boolean atStandby = false;
    @DataAttributes(description="Autochanger trucks position sensors are in error", units="unitless")
    private boolean inError = false;

    public int getDriverPosition() {
        return this.driverPosition;
    }

    public void setDriverPosition(int position) {
        this.driverPosition = position;
    }

    public int getFollowerPosition() {
        return this.followerPosition;
    }

    public void setFollowerPosition(int followerPosition) {
        this.followerPosition = followerPosition;
    }

    public int getDeltaDriverFollowerPosition() {
        return this.deltaDriverFollowerPosition;
    }

    public void setDeltaDriverFollowerPosition(int deltaDriverFollowerPosition) {
        this.deltaDriverFollowerPosition = deltaDriverFollowerPosition;
    }

    public void setDeltaDriverFollowerPosition() {
        this.setDeltaDriverFollowerPosition(this.driverPosition - this.followerPosition);
    }

    public boolean isHomingDone() {
        return this.homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

    public boolean isAtHandoff() {
        return this.atHandoff;
    }

    public void setAtHandoff(boolean atHandoff) {
        this.atHandoff = atHandoff;
    }

    public boolean isAtOnline() {
        return this.atOnline;
    }

    public void setAtOnline(boolean atOnline) {
        this.atOnline = atOnline;
    }

    public boolean isAtStandby() {
        return this.atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }

    public boolean isInError() {
        return this.inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }
}

