/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.events;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.bus.annotations.DataAttributes;

public class ShutterMotionProfileFitResult
implements Serializable {
    @DataAttributes(description="Shutter Motion Profile Fit Parameter: model start time", units="second")
    private final double modelStartTime;
    @DataAttributes(description="Shutter Motion Profile Fit Parameter: pivot point 1", units="second")
    private final double pivotPoint1;
    @DataAttributes(description="Shutter Motion Profile Fit Parameter: pivot point 2", units="second")
    private final double pivotPoint2;
    @DataAttributes(description="Shutter Motion Profile Fit Parameter: jerk 0", units="m/s^3")
    private final double jerk0;
    @DataAttributes(description="Shutter Motion Profile Fit Parameter: jerk 1", units="m/s^3")
    private final double jerk1;
    @DataAttributes(description="Shutter Motion Profile Fit Parameter: jerk 2", units="m/s^3")
    private final double jerk2;

    public ShutterMotionProfileFitResult(double[] result) {
        this.modelStartTime = result[0];
        this.pivotPoint1 = result[1];
        this.pivotPoint2 = result[2];
        this.jerk0 = result[3];
        this.jerk1 = result[4];
        this.jerk2 = result[5];
    }

    public double getModelStartTime() {
        return this.modelStartTime;
    }

    public double getPivotPoint1() {
        return this.pivotPoint1;
    }

    public double getPivotPoint2() {
        return this.pivotPoint2;
    }

    public double getJerk0() {
        return this.jerk0;
    }

    public double getJerk1() {
        return this.jerk1;
    }

    public double getJerk2() {
        return this.jerk2;
    }

    public Map<String, Object> getNamedFitParameters() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("ModelStartTime", this.modelStartTime);
        result.put("PivotPoint1", this.pivotPoint1);
        result.put("PivotPoint2", this.pivotPoint2);
        result.put("Jerk0", this.jerk0);
        result.put("Jerk1", this.jerk1);
        result.put("Jerk2", this.jerk2);
        return result;
    }

    public String toString() {
        return "ShutterMotionProfileFitResult{modelStartTime=" + this.modelStartTime + ", pivotPoint1=" + this.pivotPoint1 + ", pivotPoint2=" + this.pivotPoint2 + ", jerk0=" + this.jerk0 + ", jerk1=" + this.jerk1 + ", jerk2=" + this.jerk2 + "}";
    }
}

