/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.drivers.auxelex.BfrServer;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;

public class Bfr
extends Srp {
    public static final int RELAY_HTR_1 = 0;
    public static final int RELAY_HTR_2 = 1;
    public static final int RELAY_PWS_2 = 2;
    public static final int RELAY_PWS_3 = 3;
    public static final int RELAY_PWS_4 = 4;
    public static final int RELAY_PWS_16 = 5;
    public static final int RELAY_PWS_17 = 6;
    public static final int RELAY_PWS_18 = 7;
    public static final int RELAY_PWS_19 = 8;
    public static final int RELAY_PWS_25 = 9;
    public static final int RELAY_PWS_20 = 10;
    public static final int RELAY_PWS_21 = 11;
    public static final int NUM_RELAYS = 12;
    public static final int SENSOR_HTRS = 0;
    public static final int SENSOR_PWS_1 = 1;
    public static final int SENSOR_PWS_3 = 2;
    public static final int SENSOR_PWS_4 = 3;
    public static final int SENSOR_PWS_16 = 4;
    public static final int SENSOR_PWS_17 = 5;
    public static final int SENSOR_PWS_18 = 6;
    public static final int SENSOR_PWS_19 = 7;
    public static final int SENSOR_PWS_25 = 8;
    public static final int SENSOR_PWS_20_21 = 9;
    public static final int SENSOR_PROT = 10;
    public static final int NUM_SENSORS = 11;
    private static final Map<String, Integer> relayMap = new HashMap<String, Integer>();
    private static final int REG_RELAYS = 65536;
    private static final int REG_MBUS_CMND = 131072;
    private static final int REG_MBUS_RESP = 131074;
    private static final int REG_MBUS_RESP_RDY = 131100;
    private static final int MBUS_ADDRESS = 1;
    private static final int MBUS_FUNC_READ = 3;
    private static final int MBUS_FUNC_WRITE = 6;
    private static final int BASE_ADDR_INST = 0;
    private static final int BASE_ADDR_MIN = 1024;
    private static final int BASE_ADDR_MAX = 2048;
    private static final int BASE_ADDR_HOLD = 3072;
    private static final int OFF_ADDR_RMS = 0;
    private static final int OFF_ADDR_AC = 256;
    private static final int OFF_ADDR_DC = 512;
    private static final int TRIGGER_ADDR = 12304;
    private static final int SENSOR_READ_TMO = 170;
    private static final Map<CurrentType, Integer> offsetMap;
    private static final List<Srp.BoardType> validTypes;
    static String[] relayNames;
    private static final double CURRENT_SCALE = 100.0;
    private boolean isServer = false;
    private Socket serverSock;
    private ObjectOutputStream serverOut;
    private ObjectInputStream serverIn;
    private static final int[] simRelaySensors;
    private static final int[] simSensorRelays;
    private final int[] simCurrents = new int[13];
    private final Map<Integer, Integer> simModbus = new HashMap<Integer, Integer>();

    public Bfr() {
        this.setValidBoardTypes(validTypes);
    }

    @Override
    public synchronized void open(String host, int port) throws DriverException {
        super.open(host, port);
        boolean bl = this.isServer = (port == 8192 || port == 0) && !this.isSimulated();
        if (this.isServer) {
            try {
                BfrServer.startServer(this);
            }
            catch (DriverException e) {
                this.close();
                throw e;
            }
        }
    }

    @Override
    public void close() throws DriverException {
        if (this.isServer) {
            BfrServer.stopServer(this.getNode());
        } else {
            this.closeServer();
        }
        super.close();
    }

    public void setRelayOn(int relay) throws DriverException {
        this.writeReg(65536 + this.checkRelayNumber(relay), 1);
    }

    public void setRelayOn(String relay) throws DriverException {
        this.writeReg(65536 + this.getRelayNumber(relay), 1);
    }

    public void setRelayOn(int ... relays) throws DriverException {
        for (int relay : relays) {
            this.checkRelayNumber(relay);
        }
        for (int relay : relays) {
            this.writeReg(65536 + relay, 1);
        }
    }

    public void setRelayOn(String ... relays) throws DriverException {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (String relay : relays) {
            numbers.add(this.getRelayNumber(relay));
        }
        Iterator iterator = numbers.iterator();
        while (iterator.hasNext()) {
            int number = (Integer)iterator.next();
            this.writeReg(65536 + number, 1);
        }
    }

    public void setRelayOn() throws DriverException {
        for (int relay = 0; relay < 12; ++relay) {
            this.writeReg(65536 + relay, 1);
        }
    }

    public void setRelayOff(int relay) throws DriverException {
        this.writeReg(65536 + this.checkRelayNumber(relay), 0);
    }

    public void setRelayOff(String relay) throws DriverException {
        this.writeReg(65536 + this.getRelayNumber(relay), 0);
    }

    public void setRelayOff(int ... relays) throws DriverException {
        for (int relay : relays) {
            this.checkRelayNumber(relay);
        }
        for (int relay : relays) {
            this.writeReg(65536 + relay, 0);
        }
    }

    public void setRelayOff(String ... relays) throws DriverException {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (String relay : relays) {
            numbers.add(this.getRelayNumber(relay));
        }
        Iterator iterator = numbers.iterator();
        while (iterator.hasNext()) {
            int number = (Integer)iterator.next();
            this.writeReg(65536 + number, 0);
        }
    }

    public void setRelayOff() throws DriverException {
        for (int relay = 0; relay < 12; ++relay) {
            this.writeReg(65536 + relay, 0);
        }
    }

    public boolean isRelayOn(int relay) throws DriverException {
        return (this.readReg(65536 + this.checkRelayNumber(relay)) & 1) != 0;
    }

    public boolean isRelayOn(String relay) throws DriverException {
        return (this.readReg(65536 + this.getRelayNumber(relay)) & 1) != 0;
    }

    public boolean[] isRelayOn() throws DriverException {
        int[] regs = this.readRegs(65536, 12);
        boolean[] state = new boolean[12];
        for (int relay = 0; relay < 12; ++relay) {
            state[relay] = (regs[relay] & 1) != 0;
        }
        return state;
    }

    public double[] readCurrent(CurrentType type, int sensor, int count) throws DriverException {
        return this.readSensor(0 + offsetMap.get((Object)type), sensor, count);
    }

    public double readCurrent(CurrentType type, int sensor) throws DriverException {
        return this.readCurrent(type, sensor, 1)[0];
    }

    public double[] readCurrent(CurrentType type) throws DriverException {
        return this.readCurrent(type, 0, 11);
    }

    public double[] readMinCurrent(CurrentType type, int sensor, int count) throws DriverException {
        return this.readSensor(1024 + offsetMap.get((Object)type), sensor, count);
    }

    public double readMinCurrent(CurrentType type, int sensor) throws DriverException {
        return this.readMinCurrent(type, sensor, 1)[0];
    }

    public double[] readMinCurrent(CurrentType type) throws DriverException {
        return this.readMinCurrent(type, 0, 11);
    }

    public double[] readMaxCurrent(CurrentType type, int sensor, int count) throws DriverException {
        return this.readSensor(2048 + offsetMap.get((Object)type), sensor, count);
    }

    public double readMaxCurrent(CurrentType type, int sensor) throws DriverException {
        return this.readMaxCurrent(type, sensor, 1)[0];
    }

    public double[] readMaxCurrent(CurrentType type) throws DriverException {
        return this.readMaxCurrent(type, 0, 11);
    }

    public double[] readHeldCurrent(CurrentType type, int sensor, int count) throws DriverException {
        return this.readSensor(3072 + offsetMap.get((Object)type), sensor, count);
    }

    public double readHeldCurrent(CurrentType type, int sensor) throws DriverException {
        return this.readHeldCurrent(type, sensor, 1)[0];
    }

    public double[] readHeldCurrent(CurrentType type) throws DriverException {
        return this.readHeldCurrent(type, 0, 11);
    }

    public void resetExtrema() throws DriverException {
        if (this.isSimulated()) {
            this.simResetExtrema();
        } else {
            int[] cmnd = new int[]{17182736, 65536};
            this.writeRegs(131072, cmnd);
        }
    }

    public void triggerHold() throws DriverException {
        if (this.isSimulated()) {
            this.simTriggerHold();
        } else {
            int[] cmnd = new int[]{17182736, 0x100000};
            this.writeRegs(131072, cmnd);
        }
    }

    public static String[] getRelayNames() throws DriverException {
        return relayNames;
    }

    private double[] readSensor(int addr, int sensor, int count) throws DriverException {
        if (this.isSimulated()) {
            return this.simReadSensor(addr, sensor, count);
        }
        if (this.isServer) {
            return this.readSensorDirect(addr, sensor, count);
        }
        this.checkOpen();
        return this.sendServer(addr, sensor, count);
    }

    synchronized double[] readSensorDirect(int addr, int sensor, int count) throws DriverException {
        if (sensor < 0 || sensor >= 11) {
            throw new DriverException("Invalid sensor number: " + sensor);
        }
        if (count <= 0 || sensor + count > 11) {
            throw new DriverException("Invalid sensor count: " + count);
        }
        int[] cmnd = new int[]{0x1030000 | addr + sensor, count << 16};
        this.writeRegs(131072, cmnd);
        long endTime = System.currentTimeMillis() + 1000L;
        int resp = 0;
        while (System.currentTimeMillis() < endTime && ((resp = this.readReg(131100)) & 1) == 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!(resp & true) || resp >>> 24 == 170) {
            throw new DriverException("Current sensor read timed out");
        }
        int[] data = this.readRegs(131074, (2 * count + 6) / 4);
        int func = data[0] >> 16 & 0xFF;
        int nBytes = data[0] >> 8 & 0xFF;
        if (func >> 7 != 0) {
            throw new DriverException("Modbus read error: " + nBytes);
        }
        if (nBytes != 2 * count) {
            throw new DriverException("Incorrect returned data length: " + nBytes);
        }
        double[] values = new double[count];
        for (int j = 0; j < count; ++j) {
            values[j] = (j & 1) == 0 ? (double)(data[j / 2] << 24 >> 16 | data[j / 2 + 1] >>> 24) / 100.0 : (double)(data[j / 2 + 1] << 8 >> 16) / 100.0;
        }
        return values;
    }

    private int checkRelayNumber(int relay) throws DriverException {
        if (relay < 0 || relay >= 12) {
            throw new DriverException("Invalid relay number: " + relay);
        }
        return relay;
    }

    private int getRelayNumber(String relay) throws DriverException {
        Integer number = relayMap.get(relay);
        if (number == null) {
            throw new DriverException("Invalid relay name: " + relay);
        }
        return number;
    }

    @Override
    protected void simInitialize() {
        super.simInitialize();
        this.putSimRegMap(131100, 1);
        int[] data = new int[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112};
        System.arraycopy(data, 0, this.simCurrents, 0, 13);
        this.simWriteSensor(0, CurrentType.AC, 10, this.simCurrents[12]);
        this.simWriteSensor(0, CurrentType.RMS, 10, this.simCurrents[12]);
        this.simWriteSensor(2048, CurrentType.AC, 10, this.simCurrents[12]);
        this.simWriteSensor(2048, CurrentType.RMS, 10, this.simCurrents[12]);
        this.simWriteSensor(1024, CurrentType.AC, 10, this.simCurrents[12]);
        this.simWriteSensor(1024, CurrentType.RMS, 10, this.simCurrents[12]);
    }

    @Override
    protected void simWriteRegs(int addr, int[] value, int count) {
        int j = 0;
        while (j < count) {
            int oldValue = this.getSimRegMap(addr);
            this.putSimRegMap(addr, value[j]);
            if (addr == 131073) {
                this.putSimRegMap(131074, value[j] >> 7);
            }
            if (addr >= 65536 && addr < 65548 && oldValue != value[j]) {
                int relay = addr - 65536;
                int sensor = simRelaySensors[relay];
                int current = this.simReadSensor(0, CurrentType.AC, sensor);
                current = oldValue == 0 ? (current += this.simCurrents[relay]) : (current -= this.simCurrents[relay]);
                this.simWriteSensor(0, CurrentType.AC, sensor, current);
                this.simWriteSensor(0, CurrentType.RMS, sensor, current);
                int maxCurrent = Math.max(this.simReadSensor(2048, CurrentType.AC, sensor), current);
                this.simWriteSensor(2048, CurrentType.AC, sensor, maxCurrent);
                this.simWriteSensor(2048, CurrentType.RMS, sensor, maxCurrent);
                int minCurrent = Math.min(this.simReadSensor(1024, CurrentType.AC, sensor), current);
                this.simWriteSensor(1024, CurrentType.AC, sensor, minCurrent);
                this.simWriteSensor(1024, CurrentType.RMS, sensor, minCurrent);
            }
            ++j;
            ++addr;
        }
    }

    public void simWriteCurrent(int relay, double[] value) throws DriverException {
        if (this.isSimulated()) {
            if (relay < 0 || relay > 12) {
                throw new DriverException("Invalid relay number: " + relay);
            }
            if (relay + value.length > 13) {
                throw new DriverException("Too many values supplied: " + value.length);
            }
            int j = 0;
            while (j < value.length) {
                this.simCurrents[relay] = (int)Math.round(100.0 * value[j]);
                ++j;
                ++relay;
            }
            boolean[] relaysOn = Arrays.copyOf(this.isRelayOn(), 13);
            relaysOn[12] = true;
            int[] instValue = new int[11];
            for (int j2 = 0; j2 < 11; ++j2) {
                int relays = simSensorRelays[j2];
                int n = instValue[j2] = relaysOn[relays & 0xFF] ? this.simCurrents[relays & 0xFF] : 0;
                if ((relays >>= 8) <= 0) continue;
                int n2 = j2;
                instValue[n2] = instValue[n2] + (relaysOn[relays] ? this.simCurrents[relays] : 0);
            }
            this.simWriteSensor(0, CurrentType.AC, instValue);
            this.simWriteSensor(0, CurrentType.RMS, instValue);
            int[] maxValue = this.simReadSensor(2048, CurrentType.AC);
            for (int j3 = 0; j3 < 11; ++j3) {
                maxValue[j3] = Math.max(maxValue[j3], instValue[j3]);
            }
            this.simWriteSensor(2048, CurrentType.AC, maxValue);
            this.simWriteSensor(2048, CurrentType.RMS, maxValue);
            int[] minValue = this.simReadSensor(1024, CurrentType.AC);
            for (int j4 = 0; j4 < 11; ++j4) {
                minValue[j4] = Math.min(minValue[j4], instValue[j4]);
            }
            this.simWriteSensor(1024, CurrentType.AC, minValue);
            this.simWriteSensor(1024, CurrentType.RMS, minValue);
        }
    }

    private double[] simReadSensor(int addr, int sensor, int count) {
        double[] data = new double[count];
        for (int j = 0; j < count; ++j) {
            Integer value = this.simModbus.get(addr + sensor + j);
            data[j] = value == null ? 0.0 : (double)value.intValue() / 100.0;
        }
        return data;
    }

    private void simWriteSensor(int addr, CurrentType type, int sensor, int value) {
        this.simModbus.put(addr + offsetMap.get((Object)type) + sensor, value);
    }

    private void simWriteSensor(int addr, CurrentType type, int[] value) {
        for (int j = 0; j < 11; ++j) {
            this.simModbus.put(addr + offsetMap.get((Object)type) + j, value[j]);
        }
    }

    private int simReadSensor(int addr, CurrentType type, int sensor) {
        Integer value = this.simModbus.get(addr + offsetMap.get((Object)type) + sensor);
        return value == null ? 0 : value;
    }

    private int[] simReadSensor(int addr, CurrentType type) {
        int[] data = new int[11];
        for (int j = 0; j < 11; ++j) {
            Integer value = this.simModbus.get(addr + offsetMap.get((Object)type) + j);
            data[j] = value == null ? 0 : value;
        }
        return data;
    }

    private void simResetExtrema() {
        int[] data = this.simReadSensor(0, CurrentType.AC);
        this.simWriteSensor(1024, CurrentType.AC, data);
        this.simWriteSensor(1024, CurrentType.RMS, data);
        this.simWriteSensor(2048, CurrentType.AC, data);
        this.simWriteSensor(2048, CurrentType.RMS, data);
    }

    private void simTriggerHold() {
        int[] data = this.simReadSensor(0, CurrentType.AC);
        this.simWriteSensor(3072, CurrentType.AC, data);
        this.simWriteSensor(3072, CurrentType.RMS, data);
    }

    private void connectServer() throws DriverException {
        try {
            this.serverSock = new Socket(BfrServer.IP, BfrServer.getServerPort(this.getNode()));
            this.serverOut = new ObjectOutputStream(this.serverSock.getOutputStream());
            this.serverOut.flush();
            this.serverIn = new ObjectInputStream(this.serverSock.getInputStream());
        }
        catch (IOException e) {
            this.serverSock = null;
            throw new DriverException("Error connecting to BFR server", (Throwable)e);
        }
    }

    private void closeServer() {
        if (this.serverSock != null) {
            try {
                this.serverSock.close();
                this.serverSock = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private double[] sendServer(int addr, int sensor, int count) throws DriverException {
        if (this.serverSock == null) {
            this.connectServer();
        }
        try {
            this.serverOut.writeObject(new BfrServer.Request(addr, sensor, count));
            try {
                BfrServer.Reply reply = (BfrServer.Reply)this.serverIn.readObject();
                if (reply.ex != null) {
                    throw reply.ex;
                }
                return reply.values;
            }
            catch (IOException | ClassNotFoundException e) {
                this.closeServer();
                throw new DriverException("Error receiving from BFR server", (Throwable)e);
            }
        }
        catch (IOException e) {
            this.closeServer();
            throw new DriverException("Error sending to BFR server", (Throwable)e);
        }
    }

    static {
        relayMap.put("heater1", 0);
        relayMap.put("heater2", 1);
        relayMap.put("pws02-48VD", 2);
        relayMap.put("pws03-24VD", 3);
        relayMap.put("pws04-28V", 4);
        relayMap.put("pws16-ps0-2", 5);
        relayMap.put("pws17-ps3-5", 6);
        relayMap.put("pws18-ps6-8", 7);
        relayMap.put("pws19-ps9-10", 8);
        relayMap.put("pws25-psSpre", 9);
        relayMap.put("pws20-24VC", 10);
        relayMap.put("pws21-5V", 11);
        offsetMap = new HashMap<CurrentType, Integer>();
        offsetMap.put(CurrentType.RMS, 0);
        offsetMap.put(CurrentType.AC, 256);
        offsetMap.put(CurrentType.DC, 512);
        validTypes = new ArrayList<Srp.BoardType>();
        validTypes.add(Srp.BoardType.BFR);
        validTypes.add(Srp.BoardType.SIMULATED);
        relayNames = new String[12];
        Iterator<String> iterator = relayMap.keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            Bfr.relayNames[Bfr.relayMap.get((Object)name).intValue()] = name = iterator.next();
        }
        simRelaySensors = new int[13];
        Bfr.simRelaySensors[0] = 0;
        Bfr.simRelaySensors[1] = 0;
        Bfr.simRelaySensors[2] = 1;
        Bfr.simRelaySensors[3] = 2;
        Bfr.simRelaySensors[4] = 3;
        Bfr.simRelaySensors[5] = 4;
        Bfr.simRelaySensors[6] = 5;
        Bfr.simRelaySensors[7] = 6;
        Bfr.simRelaySensors[8] = 7;
        Bfr.simRelaySensors[10] = 9;
        Bfr.simRelaySensors[11] = 9;
        Bfr.simRelaySensors[9] = 8;
        Bfr.simRelaySensors[12] = 10;
        simSensorRelays = new int[11];
        Arrays.fill(simSensorRelays, -1);
        for (int relay = 0; relay <= 12; ++relay) {
            int sensor = simRelaySensors[relay];
            int oldRelay = simSensorRelays[sensor];
            Bfr.simSensorRelays[sensor] = oldRelay == -1 ? relay : oldRelay | relay << 8;
        }
    }

    public static enum CurrentType {
        RMS,
        AC,
        DC;

    }
}

