/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.localdb.dao.LocaldbFacade;
import org.lsst.ccs.localdb.statusdb.FastBatchPersister;
import org.lsst.ccs.localdb.statusdb.StatDataPersister;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.model.StatTimeInterval;

public class StatDataAccumulator
extends FastBatchPersister<RawData> {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private StatDataPersister statDataPersister;
    private final Map<DataDesc, Map<StatDesc, StatData>> statCache = new HashMap<DataDesc, Map<StatDesc, StatData>>();

    @Override
    public void persist(RawData data, Session sess) {
        DataDesc dd = data.getDataDesc();
        Map<StatDesc, StatData> dataCache = this.statCache.get(dd);
        if (dataCache == null) {
            dataCache = new HashMap<StatDesc, StatData>();
            this.statCache.put(dd, dataCache);
        }
        List<StatDesc> stats = StatusDataPersister.getStatDescs(dd, sess, this.log);
        long dataTime = data.getTime();
        for (StatDesc stat : stats) {
            if (data.getDoubleData() == null) continue;
            long binWidth = stat.getTimeBinWidth();
            StatTimeInterval sti = LocaldbFacade.getStatTimeInterval((long)binWidth, (long)dataTime);
            StatData cachedStat = dataCache.get(stat);
            if (cachedStat == null) {
                StatData persistedSD = LocaldbFacade.getStatDataOrNull((StatDesc)stat, (StatTimeInterval)sti, (Session)sess);
                if (persistedSD != null) {
                    this.log.fine("found existing stat data for " + persistedSD.getStatDesc().getDataDesc().getDataPath().getFullKey());
                    persistedSD.accumulate(data);
                    dataCache.put(stat, persistedSD);
                    continue;
                }
                dataCache.put(stat, new StatData(stat, data.getDoubleData().doubleValue(), sti));
                continue;
            }
            if (cachedStat.getStatTimeInterval().equals((Object)sti)) {
                cachedStat.accumulate(data);
                continue;
            }
            if (cachedStat.getStatTimeInterval().getStartTime() < sti.getStartTime()) {
                this.statDataPersister.addToQueue(cachedStat);
                StatData newStatData = LocaldbFacade.getStatDataOrNull((StatDesc)stat, (StatTimeInterval)sti, (Session)sess);
                if (newStatData != null) {
                    newStatData.accumulate(data);
                } else {
                    newStatData = new StatData(stat, data.getDoubleData().doubleValue(), sti);
                }
                dataCache.put(stat, newStatData);
                continue;
            }
            this.statDataPersister.addToQueue(cachedStat);
            StatData statData = LocaldbFacade.getStatDataOrNull((StatDesc)stat, (StatTimeInterval)sti, (Session)sess);
            if (statData != null) {
                statData.accumulate(data);
                dataCache.put(stat, statData);
            } else {
                statData = new StatData(stat, data.getDoubleData().doubleValue(), sti);
            }
            dataCache.put(stat, statData);
        }
    }

    @Override
    public void flush(Session sess) {
        for (Map.Entry<DataDesc, Map<StatDesc, StatData>> entry : this.statCache.entrySet()) {
            Iterator<Map.Entry<StatDesc, StatData>> it = entry.getValue().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<StatDesc, StatData> e = it.next();
                StatData val = e.getValue();
                this.statDataPersister.addToQueue(val);
                it.remove();
            }
        }
        this.statDataPersister.flush(sess);
    }
}

