/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class ImageDatabase
implements AutoCloseable {
    private static final int MAX_RETRIES = 1;
    private final String dbURL;
    private Connection conn;
    private PreparedStatement stmt1;
    private static final Logger LOG = Logger.getLogger(ImageDatabase.class.getName());
    private final String testStand;

    ImageDatabase(String dbURL, String testStand) {
        this.dbURL = dbURL;
        this.testStand = testStand;
    }

    ImageDAO start(ImageName currentImage) {
        ImageDAO dao = new ImageDAO();
        dao.setCurrentImage(currentImage);
        return dao;
    }

    static int raftsMaskFromLocations(LocationSet locations) {
        int raftMask = 0;
        if (locations != null) {
            for (Location location : locations) {
                raftMask |= 1 << location.index() / 4;
            }
        }
        return raftMask;
    }

    private void openConnection() throws SQLException {
        this.conn = DriverManager.getConnection(this.dbURL);
        this.conn.setAutoCommit(false);
        this.conn.setTransactionIsolation(8);
        try (PreparedStatement stmt = this.conn.prepareStatement("create table if not exists ccs_image (telCode varchar(2) not null, seqnum integer not null, dayobs varchar(8) not null, controller varchar(2) not null, darkTime float, exposureTime float, fileLocation varchar(255), imageTag bigint, imgType varchar(20), obsDate timestamp, raftMask integer, runNumber varchar(20), testType varchar(20), tseqnum integer, tstand varchar(20), primary key (telCode, seqnum, dayobs, controller), index obsDateIndex (obsDate) )");){
            stmt.execute();
        }
        this.stmt1 = this.conn.prepareStatement("insert into ccs_image (telcode, seqnum, dayobs, controller, darkTime, exposureTime, fileLocation,imageTag, imgType, obsDate, raftMask, runNumber, testType, tseqnum, tstand) values (?, ?, ?, ?, ?,        ?, ?, ?, ?, ?,         ?, ?, ?, ?, ?) ");
    }

    void insertImage(ImageDAO dao) throws SQLException {
        int i = 0;
        while (true) {
            if (this.conn == null || this.conn.isClosed()) {
                this.openConnection();
            }
            try {
                this.stmt1.setString(1, dao.imageName.getSource().getCode());
                this.stmt1.setInt(2, dao.imageName.getNumber());
                this.stmt1.setString(3, dao.imageName.getDateString());
                this.stmt1.setString(4, dao.imageName.getController().getCode());
                this.stmt1.setObject(5, dao.darkTime);
                this.stmt1.setObject(6, dao.exposureTime);
                this.stmt1.setString(7, dao.fileLocation);
                this.stmt1.setObject(8, dao.imageTag);
                this.stmt1.setString(9, dao.imageType);
                this.stmt1.setObject(10, dao.obsDate != null ? Timestamp.from(dao.obsDate) : null);
                this.stmt1.setInt(11, ImageDatabase.raftsMaskFromLocations(dao.locations));
                this.stmt1.setString(12, dao.runNumber);
                this.stmt1.setString(13, dao.testType);
                this.stmt1.setObject(14, dao.tSeqNum);
                this.stmt1.setString(15, this.testStand);
                this.stmt1.executeUpdate();
                this.conn.commit();
                LOG.log(Level.INFO, "Image database updated: {0}", dao.toString());
            }
            catch (SQLException x) {
                if (i < 1) {
                    LOG.log(Level.FINE, "Database update failed, retrying", x);
                    try {
                        this.close();
                    }
                    catch (SQLException sQLException) {}
                } else {
                    throw x;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    Connection getConnection() {
        return this.conn;
    }

    class ImageDAO {
        private ImageName imageName;
        private String imageType;
        private String testType;
        private String runNumber;
        private Integer tSeqNum;
        private String fileLocation;
        private Instant obsDate;
        private LocationSet locations;
        private Float exposureTime;
        private Float darkTime;
        private Long imageTag;

        ImageDAO() {
        }

        void addMetaData(Map<String, Serializable> metaData) {
            metaData.forEach((name, value) -> {
                switch (name) {
                    case "ExposureTime": {
                        this.exposureTime = this.toFloat(value);
                        break;
                    }
                    case "TestSeqNum": {
                        this.tSeqNum = this.toInt(value);
                        break;
                    }
                    case "TestType": {
                        this.testType = this.toString(value);
                        break;
                    }
                    case "ImageType": {
                        this.imageType = this.toString(value);
                        break;
                    }
                    case "RunNumber": {
                        this.runNumber = this.toString(value);
                    }
                }
            });
        }

        private Float toFloat(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Float) {
                return (Float)value;
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return Float.valueOf(Float.parseFloat(value.toString()));
        }

        private Integer toInt(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }

        private String toString(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        private Date toDate(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Date) {
                return (Date)value;
            }
            if (value instanceof Instant) {
                return Date.from((Instant)value);
            }
            throw new RuntimeException("Cannot convert " + value + " to date");
        }

        private void setCurrentImage(ImageName currentImage) {
            this.imageName = currentImage;
        }

        void add(FileList fileList) {
            this.fileLocation = fileList.getCommonParentDirectory().toString();
        }

        void commit() {
            try {
                ImageDatabase.this.insertImage(this);
            }
            catch (SQLException x) {
                LOG.log(Level.WARNING, x, () -> String.format("failed to write image %s to database", this.imageName));
            }
        }

        public String toString() {
            return "ImageDAO{imageName=" + this.imageName + ", imageType=" + this.imageType + ", testType=" + this.testType + ", runNumber=" + this.runNumber + ", tSeqNum=" + this.tSeqNum + ", testStand=" + ImageDatabase.this.testStand + ", fileLocation=" + this.fileLocation + ", obsDate=" + this.obsDate + ", locations=" + this.locations + ", exposureTime=" + this.exposureTime + ", darkTime=" + this.darkTime + ", imageTag=" + (Serializable)(this.imageTag == null ? this.imageTag : Long.toHexString(this.imageTag)) + "}";
        }

        void setAnnotation(String annotation) {
        }

        void setLocations(LocationSet locations) {
            this.locations = locations;
        }

        void setDarkTime(double darkTime) {
            this.darkTime = Float.valueOf((float)darkTime);
        }

        void setObsDate(Instant taiInstant) {
            this.obsDate = taiInstant;
        }

        void setDaqTag(long id) {
            this.imageTag = id;
        }
    }
}

