/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Phaser;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.data.ImageMetaDataEvent;
import org.lsst.ccs.subsystem.imagehandling.data.MeasuredShutterTime;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSImageNameEvent;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;

public class AsynchronousEventHandler {
    private static final Logger LOG = Logger.getLogger(AsynchronousEventHandler.class.getName());
    private final ConcurrentSkipListMap<ImageName, AsynchronousImageHandler> activeHandlers = new ConcurrentSkipListMap();
    private AsynchronousImageHandler currentImageHandler;
    private ImageName previousImageName;
    private final CCS ccs;
    private final OCSBridgeConfig config;

    AsynchronousEventHandler(OCSBridgeConfig config, CCS ccs) {
        this.config = config;
        this.ccs = ccs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsynchronousImageHandler create(CCSImageNameEvent ccsImageNameEvent, OCSCommandExecutor ocsCommandExecutor) {
        ImageName imageName = ccsImageNameEvent.getImageName();
        AsynchronousImageHandler handler = new AsynchronousImageHandler(ccsImageNameEvent, ocsCommandExecutor);
        this.activeHandlers.put(imageName, handler);
        ConcurrentSkipListMap<ImageName, AsynchronousImageHandler> concurrentSkipListMap = this.activeHandlers;
        synchronized (concurrentSkipListMap) {
            this.activeHandlers.notifyAll();
        }
        return handler;
    }

    CompletableFuture<AsynchronousImageHandler> getNewImageHandler(Duration waitTime) {
        CompletableFuture<AsynchronousImageHandler> result = new CompletableFuture<AsynchronousImageHandler>();
        this.ccs.runInBackground(() -> {
            try {
                LocalDateTime deadline = LocalDateTime.now().plusNanos(waitTime.toNanos());
                LOG.log(Level.INFO, "getNewImageHandler previousImageName {0}", this.previousImageName);
                while (!result.isDone() && !result.isCancelled() && LocalDateTime.now().isBefore(deadline)) {
                    Map.Entry<ImageName, AsynchronousImageHandler> lastEntry = this.activeHandlers.lastEntry();
                    if (lastEntry != null && (this.previousImageName == null || this.previousImageName.compareTo(lastEntry.getKey()) < 0)) {
                        this.currentImageHandler = lastEntry.getValue();
                        this.previousImageName = this.currentImageHandler.getImageNameEvent().getImageName();
                        LOG.log(Level.INFO, "Create image handler for {0}", this.previousImageName);
                        result.complete(this.currentImageHandler);
                        break;
                    }
                    ConcurrentSkipListMap<ImageName, AsynchronousImageHandler> concurrentSkipListMap = this.activeHandlers;
                    synchronized (concurrentSkipListMap) {
                        try {
                            LOG.log(Level.INFO, "getNewImageHandler waiting");
                            this.activeHandlers.wait(100L);
                        }
                        catch (InterruptedException ex) {
                            result.completeExceptionally(ex);
                            break;
                        }
                    }
                }
                if (!result.isDone() && !result.isCancelled()) {
                    LOG.log(Level.INFO, "getNewImageHandler timedout");
                    result.completeExceptionally(new RuntimeException("Wait for new event handler timed out"));
                }
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error in runInBackground for getNewImageHandler", t);
            }
        });
        return result;
    }

    AsynchronousImageHandler getCurrent() {
        if (this.currentImageHandler == null) {
            throw new RuntimeException("No currentImageHandler exists");
        }
        return this.currentImageHandler;
    }

    AsynchronousImageHandler getHandlerForImage(ImageName imageName) {
        AsynchronousImageHandler imageHandler = this.activeHandlers.get(imageName);
        if (imageHandler == null) {
            throw new RuntimeException("Could not find image " + imageName);
        }
        return imageHandler;
    }

    class AsynchronousImageHandler {
        private final CCSImageNameEvent imageNameEvent;
        private final Phaser endOfImageTelemetryCountdown;
        private MeasuredShutterTime measuredShutterTime;
        private ImageMetaDataEvent imageMetaDataEvent;
        private OCSCommandExecutor ocsCommandExecutor;

        private AsynchronousImageHandler(CCSImageNameEvent imageName, OCSCommandExecutor ocsCommandExecutor) {
            this.imageNameEvent = imageName;
            this.ocsCommandExecutor = ocsCommandExecutor;
            this.endOfImageTelemetryCountdown = new Phaser(3){

                @Override
                protected boolean onAdvance(int phase, int registeredParties) {
                    AsynchronousImageHandler.this.sendEndOfImageTelemetry();
                    LOG.log(Level.INFO, "Removing image handler for {0}", AsynchronousImageHandler.this.imageNameEvent.getImageName());
                    AsynchronousEventHandler.this.activeHandlers.remove(AsynchronousImageHandler.this.imageNameEvent.getImageName());
                    return true;
                }
            };
        }

        private CCSImageNameEvent getImageNameEvent() {
            return this.imageNameEvent;
        }

        void startIntegration() {
            ImageName imageName = this.imageNameEvent.getImageName();
            StartIntegrationEvent sie = StartIntegrationEvent.builder().additionalKeys(OCSBridge.DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().keySet())).additionalValues(OCSBridge.DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().values())).imagesInSequence(this.imageNameEvent.getImagesInSequence()).imageIndex(this.imageNameEvent.getSequenceNumber() + 1).imageName(imageName.toString()).imageNumber(imageName.getNumber()).imageSource(imageName.getSource().getCode()).imageController(imageName.getController().getCode()).imageDate(imageName.getDateString()).timestampAcquisitionStart(this.imageNameEvent.getIntegrationStartTime().getTAIDouble()).exposureTime(this.imageNameEvent.getExposureTime()).mode(this.imageNameEvent.getMode()).timeout(this.imageNameEvent.getTimeout()).build();
            this.sendEvent((CameraEvent)sie);
        }

        private void sendEvent(CameraEvent event) {
            this.ocsCommandExecutor.sendEvent(event);
        }

        void startReadout(CCSTimeStamp when) {
            ImageName imageName = this.imageNameEvent.getImageName();
            if (!this.imageNameEvent.isShutterOpen() || AsynchronousEventHandler.this.config.getDevice() != Camera.MAIN_CAMERA) {
                this.endOfImageTelemetryCountdown.arrive();
            }
            StartReadoutEvent sre = StartReadoutEvent.builder().additionalKeys(OCSBridge.DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().keySet())).additionalValues(OCSBridge.DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().values())).imagesInSequence(this.imageNameEvent.getImagesInSequence()).imageIndex(this.imageNameEvent.getSequenceNumber() + 1).imageName(imageName.toString()).imageNumber(imageName.getNumber()).imageSource(imageName.getSource().getCode()).imageController(imageName.getController().getCode()).imageDate(imageName.getDateString()).timestampAcquisitionStart(this.imageNameEvent.getIntegrationStartTime().getTAIDouble()).timestampStartOfReadout(when.getTAIDouble()).exposureTime(this.imageNameEvent.getExposureTime()).build();
            this.sendEvent((CameraEvent)sre);
        }

        void endReadout(CCSTimeStamp when) {
            ImageName imageName = this.imageNameEvent.getImageName();
            AsynchronousEventHandler.this.ccs.schedule(Duration.ofMillis(300L), () -> this.endOfImageTelemetryCountdown.arrive());
            AsynchronousEventHandler.this.currentImageHandler = null;
            EndReadoutEvent ere = EndReadoutEvent.builder().additionalKeys(OCSBridge.DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().keySet())).additionalValues(OCSBridge.DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().values())).imagesInSequence(this.imageNameEvent.getImagesInSequence()).imageIndex(this.imageNameEvent.getSequenceNumber() + 1).imageName(imageName.toString()).imageNumber(imageName.getNumber()).imageSource(imageName.getSource().getCode()).imageController(imageName.getController().getCode()).imageDate(imageName.getDateString()).timestampAcquisitionStart(this.imageNameEvent.getIntegrationStartTime().getTAIDouble()).timestampEndOfReadout(when.getTAIDouble()).requestedExposureTime(this.imageNameEvent.getExposureTime()).build();
            this.sendEvent((CameraEvent)ere);
        }

        void shutterTimeArrived(MeasuredShutterTime measuredShutterTime) {
            this.measuredShutterTime = measuredShutterTime;
            this.endOfImageTelemetryCountdown.arrive();
        }

        void imageMetaDataArrived(ImageMetaDataEvent imageMetaDataEvent) {
            this.imageMetaDataEvent = imageMetaDataEvent;
            this.endOfImageTelemetryCountdown.arrive();
        }

        private void sendEndOfImageTelemetry() {
            EndOfImageTelemetryEvent event = EndOfImageTelemetryEvent.builder().additionalKeys(OCSBridge.DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().keySet())).additionalValues(OCSBridge.DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().values())).imagesInSequence(this.imageNameEvent.getImagesInSequence()).imageIndex(this.imageNameEvent.getSequenceNumber() + 1).imageName(this.imageMetaDataEvent.getImageName().toString()).imageSource(this.imageMetaDataEvent.getImageName().getSource().getCode()).imageController(this.imageMetaDataEvent.getImageName().getController().getCode()).imageDate(this.imageMetaDataEvent.getImageName().getDateString()).imageNumber(this.imageMetaDataEvent.getImageName().getNumber()).timestampAcquisitionStart(this.imageMetaDataEvent.getLastClearTime().getTAIDouble()).timestampDateEnd(this.imageMetaDataEvent.getIntegrationEndTime().getTAIDouble()).timestampDateObs(this.imageMetaDataEvent.getIntegrationStartTime().getTAIDouble()).darkTime(this.imageMetaDataEvent.getDarkTime()).imageTag(this.imageMetaDataEvent.getDaqTag()).exposureTime(this.imageNameEvent.getExposureTime()).measuredShutterOpenTime(this.measuredShutterTime != null ? this.measuredShutterTime.getMeasuredShutterOpenTime() : this.imageNameEvent.getRequestedShutterOpenTime()).emulatedImage(this.imageMetaDataEvent.getEmulatedImageName() == null ? "" : this.imageMetaDataEvent.getEmulatedImageName()).build();
            this.sendEvent((CameraEvent)event);
        }
    }
}

