/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.hub;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.astrogrid.samp.ShutdownManager;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.hub.HubProfile;
import org.astrogrid.samp.hub.HubProfileFactory;
import org.astrogrid.samp.hub.HubService;
import org.astrogrid.samp.hub.HubServiceMode;
import org.astrogrid.samp.hub.KeyGenerator;
import org.astrogrid.samp.web.WebHubProfile;
import org.astrogrid.samp.web.WebHubProfileFactory;
import org.astrogrid.samp.xmlrpc.StandardHubProfile;
import org.astrogrid.samp.xmlrpc.StandardHubProfileFactory;

public class Hub {
    private final HubService service_;
    private final List profileList_;
    private static Class[] defaultDefaultProfileClasses_;
    private static Class[] defaultDefaultExtraProfileClasses_;
    private static Class[] defaultProfileClasses_;
    private static Class[] defaultExtraProfileClasses_;
    private static final Map hubList_;
    private static final Logger logger_;
    public static final String HUBPROFILES_PROP = "jsamp.hub.profiles";
    public static final String EXTRAHUBPROFILES_PROP = "jsamp.hub.profiles.extra";
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hub(HubService service) {
        this.service_ = service;
        this.profileList_ = new ArrayList();
        Map map = hubList_;
        synchronized (map) {
            hubList_.put(this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        logger_.info("Shutting down hub service");
        try {
            this.service_.shutdown();
        }
        catch (Throwable e) {
            logger_.log(Level.WARNING, "Service shutdown error: " + e, e);
        }
        Iterator it = this.profileList_.iterator();
        while (it.hasNext()) {
            HubProfile profile = (HubProfile)it.next();
            logger_.info("Shutting down hub profile " + profile.getProfileName());
            try {
                profile.stop();
            }
            catch (IOException e) {
                logger_.log(Level.WARNING, "Failed to stop profile " + profile.getProfileName(), e);
            }
            it.remove();
        }
        Map map = hubList_;
        synchronized (map) {
            hubList_.remove(this);
        }
        ShutdownManager.getInstance().unregisterHook(this);
    }

    public synchronized void startProfile(final HubProfile profile) throws IOException {
        if (this.profileList_.contains(profile)) {
            logger_.info("Profile " + profile.getProfileName() + " already started in this hub");
        } else {
            profile.start(new ClientProfile(){

                public HubConnection register() throws SampException {
                    return Hub.this.service_.register(profile);
                }

                public boolean isHubRunning() {
                    return Hub.this.service_.isHubRunning();
                }
            });
            this.profileList_.add(profile);
        }
    }

    public synchronized void stopProfile(HubProfile profile) {
        logger_.info("Shutting down hub profile " + profile.getProfileName() + " and disconnecting clients");
        try {
            profile.stop();
        }
        catch (IOException e) {
            logger_.log(Level.WARNING, "Failed to stop profile " + profile.getProfileName(), e);
        }
        this.profileList_.remove(profile);
        this.service_.disconnectAll(profile);
    }

    public HubService getHubService() {
        return this.service_;
    }

    public HubProfile[] getRunningProfiles() {
        return this.profileList_.toArray(new HubProfile[0]);
    }

    public JFrame getWindow() {
        return null;
    }

    public static HubProfileFactory[] getKnownHubProfileFactories() {
        return new HubProfileFactory[]{new StandardHubProfileFactory(), new WebHubProfileFactory()};
    }

    public static Class[] getDefaultProfileClasses(boolean extra) {
        return (Class[])(extra ? defaultExtraProfileClasses_ : defaultProfileClasses_).clone();
    }

    public static void setDefaultProfileClasses(Class[] clazzes, boolean extra) {
        for (int ip = 0; ip < clazzes.length; ++ip) {
            Class clazz;
            if ((class$org$astrogrid$samp$hub$HubProfile == null ? Hub.class$("org.astrogrid.samp.hub.HubProfile") : class$org$astrogrid$samp$hub$HubProfile).isAssignableFrom(clazz = clazzes[ip])) continue;
            throw new IllegalArgumentException("Class " + clazz.getName() + " not a HubProfile");
        }
        clazzes = (Class[])clazzes.clone();
        if (extra) {
            defaultExtraProfileClasses_ = clazzes;
        } else {
            defaultProfileClasses_ = clazzes;
        }
    }

    private static Class[] createDefaultProfileClasses(boolean extra) {
        String listTxt = System.getProperty(extra ? EXTRAHUBPROFILES_PROP : HUBPROFILES_PROP);
        if (listTxt != null) {
            HubProfileFactory[] facts = Hub.parseProfileList(listTxt);
            Class[] clazzes = new Class[facts.length];
            for (int i = 0; i < facts.length; ++i) {
                clazzes[i] = facts[i].getHubProfileClass();
            }
            return clazzes;
        }
        return extra ? defaultDefaultExtraProfileClasses_ : defaultDefaultProfileClasses_;
    }

    public static HubProfileFactory[] parseProfileList(String listTxt) {
        String[] txtItems = listTxt == null || listTxt.trim().length() == 0 ? new String[]{} : listTxt.split(",");
        ArrayList<HubProfileFactory> factoryList = new ArrayList<HubProfileFactory>();
        for (int i = 0; i < txtItems.length; ++i) {
            factoryList.add(Hub.parseProfileClass(txtItems[i]));
        }
        return factoryList.toArray(new HubProfileFactory[0]);
    }

    private static HubProfileFactory parseProfileClass(String txt) {
        Class<?> clazz;
        HubProfileFactory[] profFacts = Hub.getKnownHubProfileFactories();
        for (int i = 0; i < profFacts.length; ++i) {
            if (!txt.equals(profFacts[i].getName())) continue;
            return profFacts[i];
        }
        try {
            clazz = Class.forName(txt);
        }
        catch (ClassNotFoundException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("No known hub/class " + txt).initCause(e);
        }
        if (HubProfile.class.isAssignableFrom(clazz)) {
            return new HubProfileFactory(){

                public Class getHubProfileClass() {
                    return clazz;
                }

                public String[] getFlagsUsage() {
                    return new String[0];
                }

                public String getName() {
                    return clazz.getName();
                }

                public HubProfile createHubProfile(List flagList) throws IOException {
                    try {
                        return (HubProfile)clazz.newInstance();
                    }
                    catch (IllegalAccessException e) {
                        throw (IOException)new IOException("Can't create " + clazz.getName() + " instance").initCause(e);
                    }
                    catch (InstantiationException e) {
                        throw (IOException)new IOException("Can't create " + clazz.getName() + " instance").initCause(e);
                    }
                    catch (ExceptionInInitializerError e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof IOException) {
                            throw (IOException)cause;
                        }
                        throw (IOException)new IOException("Can't create " + clazz.getName() + " instance").initCause(e);
                    }
                }
            };
        }
        throw new IllegalArgumentException(clazz + " is not a " + HubProfile.class.getName());
    }

    public static HubProfile[] createDefaultProfiles(boolean extra) {
        Class[] clazzes = Hub.getDefaultProfileClasses(extra);
        ArrayList<HubProfile> hubProfileList = new ArrayList<HubProfile>();
        for (int ip = 0; ip < clazzes.length; ++ip) {
            Class clazz = clazzes[ip];
            try {
                hubProfileList.add((HubProfile)clazz.newInstance());
                continue;
            }
            catch (ClassCastException e) {
                logger_.warning("No hub profile " + clazz.getName() + " - not a " + (class$org$astrogrid$samp$hub$HubProfile == null ? Hub.class$("org.astrogrid.samp.hub.HubProfile") : class$org$astrogrid$samp$hub$HubProfile).getName());
                continue;
            }
            catch (InstantiationException e) {
                logger_.warning("No hub profile " + clazz.getName() + " - failed to instantiate (" + e + ")");
                continue;
            }
            catch (IllegalAccessException e) {
                logger_.warning("No hub profile " + clazz.getName() + " - inaccessible constructor (" + e + ")");
                continue;
            }
            catch (ExceptionInInitializerError e) {
                logger_.warning("No hub profile " + clazz.getName() + " - construction error" + " (" + e.getCause() + ")");
            }
        }
        return hubProfileList.toArray(new HubProfile[0]);
    }

    public static Hub runHub(HubServiceMode hubMode, HubProfile[] profiles, HubProfile[] extraProfiles) throws IOException {
        Hub hub;
        if (profiles == null) {
            profiles = Hub.createDefaultProfiles(false);
        }
        if (extraProfiles == null) {
            extraProfiles = Hub.createDefaultProfiles(true);
        }
        ArrayList<HubProfile> profList = new ArrayList<HubProfile>();
        profList.addAll(Arrays.asList(profiles));
        for (int ip = 0; ip < extraProfiles.length; ++ip) {
            HubProfile ep = extraProfiles[ip];
            boolean gotit = false;
            for (int jp = 0; jp < profiles.length; ++jp) {
                gotit = gotit || profiles[jp].getClass().equals(ep.getClass());
            }
            if (gotit) continue;
            profList.add(ep);
        }
        HubProfile[] allProfiles = profList.toArray(new HubProfile[0]);
        Hub[] runners = new Hub[1];
        final HubServiceMode.ServiceGui serviceGui = hubMode.createHubService(KeyGenerator.createRandom(), allProfiles, runners);
        HubService hubService = serviceGui.getHubService();
        runners[0] = hub = new Hub(hubService){

            public JFrame getWindow() {
                return serviceGui.getWindow();
            }
        };
        int nStarted = 0;
        IOException error1 = null;
        for (int ip = 0; ip < profiles.length; ++ip) {
            HubProfile prof = profiles[ip];
            String pname = prof.getProfileName();
            try {
                logger_.info("Starting hub profile " + pname);
                hub.startProfile(prof);
                ++nStarted;
                continue;
            }
            catch (IOException e) {
                if (error1 == null) {
                    error1 = e;
                }
                logger_.log(Level.WARNING, "Failed to start SAMP hub profile " + pname, e);
            }
        }
        logger_.info("Started " + nStarted + "/" + profiles.length + " SAMP profiles");
        if (nStarted == 0 && profiles.length > 0) {
            if (!$assertionsDisabled && error1 == null) {
                throw new AssertionError();
            }
            throw (IOException)new IOException("No SAMP profiles started: " + error1).initCause(error1);
        }
        logger_.info("Starting hub service");
        hubService.start();
        ShutdownManager.getInstance().registerHook(hub, 200, new Runnable(){

            public void run() {
                hub.shutdown();
            }
        });
        return hub;
    }

    public static Hub runHub(HubServiceMode hubMode) throws IOException {
        return Hub.runHub(hubMode, null, null);
    }

    public static void runExternalHub(HubServiceMode hubMode, Class[] profileClasses, Class[] extraProfileClasses) throws IOException {
        String classpath = System.getProperty("java.class.path");
        if (classpath == null || classpath.trim().length() == 0) {
            throw new IOException("No classpath available - JNLP context?");
        }
        File javaHome = new File(System.getProperty("java.home"));
        File javaExec = new File(new File(javaHome, "bin"), "java");
        String javacmd = javaExec.exists() && !javaExec.isDirectory() ? javaExec.toString() : "java";
        String[] propagateProps = new String[]{"jsamp.xmlrpc.impl", "jsamp.server.port", "jsamp.localhost", HUBPROFILES_PROP, EXTRAHUBPROFILES_PROP, "java.awt.Window.locationByPlatform"};
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(javacmd);
        for (int ip = 0; ip < propagateProps.length; ++ip) {
            String propName = propagateProps[ip];
            String propVal = System.getProperty(propName);
            if (propVal == null) continue;
            argList.add("-D" + propName + "=" + propVal);
        }
        argList.add("-classpath");
        argList.add(classpath);
        argList.add(Hub.class.getName());
        argList.add("-mode");
        argList.add(hubMode.toString());
        if (profileClasses != null) {
            argList.add("-profiles");
            StringBuffer profArg = new StringBuffer();
            for (int ip = 0; ip < profileClasses.length; ++ip) {
                if (ip > 0) {
                    profArg.append(',');
                }
                profArg.append(profileClasses[ip].getName());
            }
            argList.add(profArg.toString());
        }
        if (extraProfileClasses != null) {
            argList.add("-extraprofiles");
            StringBuffer eprofArg = new StringBuffer();
            for (int ip = 0; ip < profileClasses.length; ++ip) {
                if (ip > 0) {
                    eprofArg.append(',');
                }
                eprofArg.append(extraProfileClasses[ip].getName());
            }
            argList.add(eprofArg.toString());
        }
        String[] args = argList.toArray(new String[0]);
        StringBuffer cmdbuf = new StringBuffer();
        for (int iarg = 0; iarg < args.length; ++iarg) {
            if (iarg > 0) {
                cmdbuf.append(' ');
            }
            cmdbuf.append(args[iarg]);
        }
        logger_.info("Starting external hub");
        logger_.info(cmdbuf.toString());
        Hub.execBackground(args);
    }

    public static void runExternalHub(HubServiceMode hubMode) throws IOException {
        Hub.runExternalHub(hubMode, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hub[] getRunningHubs() {
        ArrayList list;
        Map map = hubList_;
        synchronized (map) {
            list = new ArrayList(hubList_.keySet());
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Hub hub = (Hub)it.next();
            if (hub.getHubService().isHubRunning()) continue;
            it.remove();
        }
        return list.toArray(new Hub[0]);
    }

    public static void checkExternalHubAvailability() throws IOException {
        String classpath = System.getProperty("java.class.path");
        if (classpath == null || classpath.trim().length() == 0) {
            throw new IOException("No classpath available - JNLP context?");
        }
        if (System.getProperty("jnlpx.jvm") != null) {
            throw new IOException("Running under WebStart - external hub not likely to work");
        }
    }

    public static void main(String[] args) {
        try {
            int status = Hub.runMain(args);
            if (status != 0) {
                System.exit(status);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runMain(String[] args) throws IOException {
        HubProfileFactory[] knownProfileFactories = Hub.getKnownHubProfileFactories();
        StringBuffer pbuf = new StringBuffer();
        for (int ip = 0; ip < knownProfileFactories.length; ++ip) {
            pbuf.append(knownProfileFactories[ip].getName()).append('|');
        }
        pbuf.append("<hubprofile-class>").append("[,...]");
        String profUsage = pbuf.toString();
        StringBuffer ubuf = new StringBuffer();
        ubuf.append("\n   Usage:").append("\n      ").append(Hub.class.getName()).append("\n           ").append(" [-help]").append(" [-/+verbose]").append("\n           ").append(" [-mode ");
        HubServiceMode[] modes = HubServiceMode.getAvailableModes();
        for (int im = 0; im < modes.length; ++im) {
            if (im > 0) {
                ubuf.append('|');
            }
            ubuf.append(modes[im].getName());
        }
        ubuf.append(']').append("\n           ").append(" [").append("-profiles ").append(profUsage).append("]").append("\n           ").append(" [").append("-extraprofiles ").append(profUsage).append("]");
        for (int ip = 0; ip < knownProfileFactories.length; ++ip) {
            ArrayList<String> pusageList = new ArrayList<String>(Arrays.asList(knownProfileFactories[ip].getFlagsUsage()));
            while (!pusageList.isEmpty()) {
                StringBuffer sbuf = new StringBuffer().append("\n           ");
                Iterator it = pusageList.iterator();
                while (it.hasNext()) {
                    String pusage = (String)it.next();
                    if (sbuf.length() + pusage.length() >= 78) break;
                    sbuf.append(' ').append(pusage);
                    it.remove();
                }
                ubuf.append(sbuf);
            }
        }
        ubuf.append('\n');
        String usage = ubuf.toString();
        HubServiceMode hubMode = HubServiceMode.MESSAGE_GUI;
        if (!Arrays.asList(HubServiceMode.getAvailableModes()).contains(hubMode)) {
            hubMode = HubServiceMode.NO_GUI;
        }
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        int verbAdjust = 0;
        Object stdSecret = null;
        boolean stdHttplock = false;
        String webAuth = "swing";
        String webLog = "none";
        boolean webRemote = false;
        String profilesTxt = null;
        String extraProfilesTxt = null;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-mode") && it.hasNext()) {
                it.remove();
                String mode = (String)it.next();
                it.remove();
                hubMode = HubServiceMode.getModeFromName(mode);
                if (hubMode != null) continue;
                System.err.println("Unkown mode " + mode);
                System.err.println(usage);
                return 1;
            }
            if (arg.equals("-profiles")) {
                it.remove();
                if (it.hasNext()) {
                    profilesTxt = (String)it.next();
                    it.remove();
                    continue;
                }
                System.err.println(usage);
                return 1;
            }
            if (arg.equals("-extraprofiles")) {
                it.remove();
                if (it.hasNext()) {
                    extraProfilesTxt = (String)it.next();
                    it.remove();
                    continue;
                }
                System.err.println(usage);
                return 1;
            }
            if (arg.equals("-v") || arg.equals("-verbose")) {
                it.remove();
                --verbAdjust;
                continue;
            }
            if (arg.equals("+v") || arg.equals("+verbose")) {
                it.remove();
                ++verbAdjust;
                continue;
            }
            if (!arg.equals("-h") && !arg.equals("-help")) continue;
            it.remove();
            System.out.println(usage);
            return 0;
        }
        int logLevel = Level.WARNING.intValue() + 100 * verbAdjust;
        Logger.getLogger("org.astrogrid.samp").setLevel(Level.parse(Integer.toString(logLevel)));
        HubProfile[] profiles = Hub.getProfiles(profilesTxt, argList, false, "-profiles " + profUsage);
        if (profiles == null) {
            return 1;
        }
        HubProfile[] extraProfiles = Hub.getProfiles(extraProfilesTxt, argList, true, "-extraprofiles " + profUsage);
        if (profiles == null) {
            return 1;
        }
        if (!argList.isEmpty()) {
            System.err.println("Some args not used " + argList);
            System.err.println(usage);
            return 1;
        }
        Hub.runHub(hubMode, profiles, extraProfiles);
        if (hubMode.isDaemon()) {
            String lock;
            String string = lock = new String("Indefinite");
            synchronized (string) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    private static HubProfile[] getProfiles(String profTxt, List argList, boolean isExtra, String usage) throws IOException {
        HubProfileFactory[] pfacts;
        if (profTxt == null) {
            Object[] dflts;
            Object[] objectArray = dflts = isExtra ? defaultDefaultExtraProfileClasses_ : defaultDefaultProfileClasses_;
            if (Arrays.equals(Hub.createDefaultProfileClasses(isExtra), dflts)) {
                profTxt = isExtra ? "" : "std,web";
            } else {
                logger_.warning("Non-default profiles set external to flags; web: and std: flags will be ignored");
                return Hub.createDefaultProfiles(isExtra);
            }
        }
        try {
            pfacts = Hub.parseProfileList(profTxt);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.err.println(usage);
            return null;
        }
        HubProfile[] profiles = new HubProfile[pfacts.length];
        for (int i = 0; i < pfacts.length; ++i) {
            HubProfileFactory pfact = pfacts[i];
            try {
                profiles[i] = pfact.createHubProfile(argList);
                continue;
            }
            catch (RuntimeException e) {
                System.err.println("Error configuring profile " + pfact.getName() + ":\n" + e.getMessage());
                return null;
            }
        }
        return profiles;
    }

    private static void execBackground(String[] cmdarray) throws IOException {
        Process process = Runtime.getRuntime().exec(cmdarray);
        Hub.discardBytes(process.getInputStream());
        Hub.discardBytes(process.getErrorStream());
    }

    private static void discardBytes(final InputStream in) {
        Thread eater = new Thread("StreamEater"){

            public void run() {
                try {
                    while (in.read() >= 0) {
                    }
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        eater.setDaemon(true);
        eater.start();
    }

    static {
        $assertionsDisabled = !Hub.class.desiredAssertionStatus();
        defaultDefaultProfileClasses_ = new Class[]{StandardHubProfile.class, WebHubProfile.class};
        defaultDefaultExtraProfileClasses_ = new Class[0];
        defaultProfileClasses_ = Hub.createDefaultProfileClasses(false);
        defaultExtraProfileClasses_ = Hub.createDefaultProfileClasses(true);
        hubList_ = new WeakHashMap();
        logger_ = Logger.getLogger(Hub.class.getName());
    }
}

