/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.visualization.rest;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import org.lsst.ccs.web.visualization.rest.FakeImageProvider;
import org.lsst.ccs.web.visualization.rest.ImageQueue;
import org.lsst.ccs.web.visualization.rest.RestServer;

public class Main {
    private static String PORT = "8080";

    public static void main(String[] args) throws IOException {
        if (args.length == 1) {
            PORT = args[0];
        }
        URI baseURI = URI.create("http://localhost:" + PORT + "/vis/");
        System.out.println("PORT: " + PORT);
        System.out.println("BASE_URI: " + baseURI);
        ImageQueue imageQueue = new ImageQueue();
        try (RestServer restServer = new RestServer();){
            restServer.start(imageQueue, baseURI);
            try (FakeImageProvider provider = new FakeImageProvider(imageQueue);){
                provider.start(Duration.ofSeconds(10L));
                System.in.read();
            }
        }
    }
}

