/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.i2c;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.i2c.I2cImplUsb;

public class I2c {
    private static final Map<String, OpenDesc> openMap = new HashMap<String, OpenDesc>();
    private OpenDesc desc;

    public void open(String ident, int param) throws DriverException {
        if (this.desc != null) {
            throw new DriverException("Connection already open");
        }
        this.desc = I2c.getOpen(ident);
    }

    public void close() throws DriverException {
        this.checkOpen();
        I2c.dropOpen(this.desc);
        this.desc = null;
    }

    public void setTimeout(double timeout) throws DriverException {
        this.checkOpen();
        this.desc.impl.setTimeout(timeout);
    }

    public void write(int addr, int value) throws DriverException {
        this.checkOpen();
        this.desc.impl.write(addr, value);
    }

    public int read(int addr) throws DriverException {
        this.checkOpen();
        return this.desc.impl.read(addr);
    }

    public int read(int addr, byte[] buff, int count) throws DriverException {
        this.checkOpen();
        return this.desc.impl.read(addr, buff, count);
    }

    public int read(int addr, byte[] buff) throws DriverException {
        return this.read(addr, buff, buff.length);
    }

    public void write(int addr, int reg, byte[] buff, int count) throws DriverException {
        this.checkOpen();
        this.desc.impl.write(addr, reg, buff, count);
    }

    public void write(int addr, int reg, byte[] buff) throws DriverException {
        this.write(addr, reg, buff, buff.length);
    }

    public int read(int addr, int reg, byte[] buff, int count) throws DriverException {
        this.checkOpen();
        return this.desc.impl.read(addr, reg, buff, count);
    }

    public int read(int addr, int reg, byte[] buff) throws DriverException {
        return this.read(addr, reg, buff, buff.length);
    }

    public void write2(int addr, int reg, byte[] buff, int count) throws DriverException {
        this.checkOpen();
        this.desc.impl.write2(addr, reg, buff, count);
    }

    public void write2(int addr, int reg, byte[] buff) throws DriverException {
        this.write2(addr, reg, buff, buff.length);
    }

    public int read2(int addr, int reg, byte[] buff, int count) throws DriverException {
        this.checkOpen();
        return this.desc.impl.read2(addr, reg, buff, count);
    }

    public int read2(int addr, int reg, byte[] buff) throws DriverException {
        return this.read2(addr, reg, buff, buff.length);
    }

    private static synchronized OpenDesc getOpen(String ident) throws DriverException {
        String key = ident;
        OpenDesc desc = openMap.get(key);
        if (desc == null) {
            desc = new OpenDesc();
            desc.impl = new I2cImplUsb();
            openMap.put(key, desc);
        }
        if (desc.refCount <= 0) {
            desc.impl.open(ident, 0);
        }
        ++desc.refCount;
        return desc;
    }

    private static synchronized void dropOpen(OpenDesc desc) throws DriverException {
        if (--desc.refCount <= 0) {
            desc.impl.close();
        }
    }

    private void checkOpen() throws DriverException {
        if (this.desc == null) {
            throw new DriverException("Connection not open");
        }
    }

    static class OpenDesc {
        Impl impl;
        int refCount = 0;

        OpenDesc() {
        }
    }

    static interface Impl {
        public void open(String var1, int var2) throws DriverException;

        public void close() throws DriverException;

        default public void setTimeout(double timeout) throws DriverException {
            throw new DriverException("setTimeout method not implemented");
        }

        default public void write(int addr, int value) throws DriverException {
            throw new DriverException("Write single method not implemented");
        }

        default public int read(int addr) throws DriverException {
            throw new DriverException("Read single method not implemented");
        }

        default public int read(int addr, byte[] buff, int count) throws DriverException {
            throw new DriverException("Read multiple method not implemented");
        }

        default public void write(int addr, int reg, byte[] buff, int count) throws DriverException {
            throw new DriverException("Write method not implemented");
        }

        default public int read(int addr, int reg, byte[] buff, int count) throws DriverException {
            throw new DriverException("Read method not implemented");
        }

        default public void write2(int addr, int reg, byte[] buff, int count) throws DriverException {
            throw new DriverException("Write method not implemented");
        }

        default public int read2(int addr, int reg, byte[] buff, int count) throws DriverException {
            throw new DriverException("Read method not implemented");
        }
    }
}

