/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.guider.ClearParameters;
import org.lsst.ccs.daq.guider.Config;
import org.lsst.ccs.daq.guider.GuiderListener;
import org.lsst.ccs.daq.guider.ROICommon;
import org.lsst.ccs.daq.guider.ROICommonExtended;
import org.lsst.ccs.daq.guider.ROILocation;
import org.lsst.ccs.daq.guider.SeriesMetaData;
import org.lsst.ccs.daq.guider.SeriesStatus;
import org.lsst.ccs.daq.guider.StateMetaData;
import org.lsst.ccs.daq.guider.Status;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.location.SensorLocation;

public class Guider {
    private final Store store;
    private final long guider;

    public Guider(Store store, long guider) {
        this.store = store;
        this.guider = guider;
    }

    public Status start(ROICommon common, List<ROILocation> locations) throws DAQException {
        return this.start(common, locations, null);
    }

    public Status start(ROICommon common, List<ROILocation> locations, String id) throws DAQException {
        return this.start(new ROICommonExtended(common), locations, id);
    }

    public Status start(ROICommonExtended common, List<ROILocation> locations, String id) throws DAQException {
        int nLocs = locations.size();
        int[] roiData = new int[nLocs * 5];
        for (int i = 0; i < nLocs; ++i) {
            int j = i * 5;
            ROILocation location = locations.get(i);
            SensorLocation sensorLocation = location.getLocation();
            roiData[j] = sensorLocation.getRebLocation().index();
            roiData[j + 1] = sensorLocation.getSensor();
            roiData[j + 2] = location.getSegment();
            roiData[j + 3] = location.getStartRow();
            roiData[j + 4] = location.getStartCol();
        }
        return this.store.startGuider(this.guider, common.getRows(), common.getCols(), common.getIntegrationTimeMillis(), common.getOverRows(), common.getUnderCols(), common.getOverCols(), common.getFlushCount(), id, roiData);
    }

    public void validate(ROICommon common, List<ROILocation> locations) throws DAQException {
        int nLocs = locations.size();
        int[] roiData = new int[nLocs * 5];
        for (int i = 0; i < nLocs; ++i) {
            int j = i * 5;
            ROILocation location = locations.get(i);
            SensorLocation sensorLocation = location.getLocation();
            roiData[j] = sensorLocation.getRebLocation().index();
            roiData[j + 1] = sensorLocation.getSensor();
            roiData[j + 2] = location.getSegment();
            roiData[j + 3] = location.getStartRow();
            roiData[j + 4] = location.getStartCol();
        }
        this.store.validateGuider(this.guider, common.getRows(), common.getCols(), common.getIntegrationTimeMillis(), roiData);
    }

    public Subscriber subscribe(Set<SensorLocation> locations, ByteOrder byteOrder, GuiderListener listener) throws DAQException {
        return new Subscriber(this.store, locations, byteOrder, listener);
    }

    public Status stop() throws DAQException {
        return this.stop(null);
    }

    public Status stop(String comment) throws DAQException {
        return this.store.stopGuider(this.guider, comment);
    }

    public Status pause() throws DAQException {
        return this.pause(null);
    }

    public Status pause(String comment) throws DAQException {
        return this.store.pauseGuider(this.guider, comment);
    }

    public Status resume() throws DAQException {
        return this.resume(null);
    }

    public Status resume(String comment) throws DAQException {
        return this.store.resumeGuider(this.guider, comment);
    }

    public Status sleep() throws DAQException {
        return this.store.sleepGuider(this.guider);
    }

    public Status wake() throws DAQException {
        return this.wake(ClearParameters.defaultValue());
    }

    public Status wake(ClearParameters clearParameters) throws DAQException {
        return this.store.wakeGuider(this.guider, clearParameters);
    }

    public Status clear(ClearParameters clearParameters) throws DAQException {
        return this.store.clearGuider(this.guider, clearParameters);
    }

    public Config config() throws DAQException {
        return this.store.guiderConfig(this.guider);
    }

    public SeriesStatus series() throws DAQException {
        return this.store.guiderSeries(this.guider);
    }

    void detach() throws DAQException {
        this.store.detachGuider(this.guider);
    }

    public String getPartition() {
        return this.store.getPartition();
    }

    public LocationSet getConfiguredLocations() throws DAQException {
        return this.store.getConfiguredLocations();
    }

    public String getClientPlatform() throws DAQException {
        return this.store.getClientPlatform();
    }

    public static class Subscriber
    implements AutoCloseable {
        private static final Logger LOG = Logger.getLogger(Subscriber.class.getName());
        private volatile long subscriber;
        private volatile Thread waitThread;
        private final Store store;
        private final GuiderListener listener;

        private Subscriber(Store store, Set<SensorLocation> locations, ByteOrder byteOrder, GuiderListener listener) throws DAQException {
            this.store = store;
            this.listener = listener;
            boolean bigEndian = byteOrder == ByteOrder.BIG_ENDIAN;
            int[] locs = new int[locations.size() * 2];
            int index = 0;
            for (SensorLocation sl : locations) {
                locs[index++] = sl.getRebLocation().index();
                locs[index++] = sl.getSensor();
            }
            this.subscriber = store.attachGuiderSubscriber(store.getPartition(), bigEndian, locs);
        }

        public void waitForGuider() throws DAQException {
            long sub = this.subscriber;
            if (sub == 0L) {
                throw new DAQException("Subscriber already closed");
            }
            this.waitThread = Thread.currentThread();
            this.store.waitForGuider(sub, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startCallback(StateMetaData state, SeriesMetaData series) {
            long start = System.nanoTime();
            try {
                this.listener.start(state, series);
            }
            catch (Exception x) {
                try {
                    LOG.log(Level.WARNING, "start callback failed", x);
                }
                catch (Throwable throwable) {
                    long stop = System.nanoTime();
                    LOG.log(Level.INFO, "start took {0}ns {1} {2}", new Object[]{stop - start, state, series});
                    throw throwable;
                }
                long stop = System.nanoTime();
                LOG.log(Level.INFO, "start took {0}ns {1} {2}", new Object[]{stop - start, state, series});
            }
            long stop = System.nanoTime();
            LOG.log(Level.INFO, "start took {0}ns {1} {2}", new Object[]{stop - start, state, series});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopCallback(StateMetaData state) {
            long start = System.nanoTime();
            try {
                this.listener.stop(state);
            }
            catch (Exception x) {
                try {
                    LOG.log(Level.WARNING, "stop callback failed", x);
                }
                catch (Throwable throwable) {
                    long stop = System.nanoTime();
                    LOG.log(Level.INFO, "stop took {0}ns {1}", new Object[]{stop - start, state});
                    throw throwable;
                }
                long stop = System.nanoTime();
                LOG.log(Level.INFO, "stop took {0}ns {1}", new Object[]{stop - start, state});
            }
            long stop = System.nanoTime();
            LOG.log(Level.INFO, "stop took {0}ns {1}", new Object[]{stop - start, state});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pauseCallback(StateMetaData state) {
            long start = System.nanoTime();
            try {
                this.listener.pause(state);
            }
            catch (Exception x) {
                try {
                    LOG.log(Level.WARNING, "pause callback failed", x);
                }
                catch (Throwable throwable) {
                    long stop = System.nanoTime();
                    LOG.log(Level.INFO, "pause took {0}ns {1}", new Object[]{stop - start, state});
                    throw throwable;
                }
                long stop = System.nanoTime();
                LOG.log(Level.INFO, "pause took {0}ns {1}", new Object[]{stop - start, state});
            }
            long stop = System.nanoTime();
            LOG.log(Level.INFO, "pause took {0}ns {1}", new Object[]{stop - start, state});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resumeCallback(StateMetaData state) {
            long start = System.nanoTime();
            try {
                this.listener.resume(state);
            }
            catch (Exception x) {
                try {
                    LOG.log(Level.WARNING, "resume callback failed", x);
                }
                catch (Throwable throwable) {
                    long stop = System.nanoTime();
                    LOG.log(Level.INFO, "resume took {0}ns {1}", new Object[]{stop - start, state});
                    throw throwable;
                }
                long stop = System.nanoTime();
                LOG.log(Level.INFO, "resume took {0}ns {1}", new Object[]{stop - start, state});
            }
            long stop = System.nanoTime();
            LOG.log(Level.INFO, "resume took {0}ns {1}", new Object[]{stop - start, state});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rawStampCallback(StateMetaData state, ByteBuffer rawStamp) {
            long start = System.nanoTime();
            try {
                this.listener.rawStamp(state, rawStamp);
            }
            catch (Exception x) {
                try {
                    LOG.log(Level.WARNING, "rawStamp callback failed", x);
                }
                catch (Throwable throwable) {
                    long stop = System.nanoTime();
                    LOG.log(Level.INFO, "rawStamp took {0}ns {1} {2}", new Object[]{stop - start, state, rawStamp.remaining()});
                    throw throwable;
                }
                long stop = System.nanoTime();
                LOG.log(Level.INFO, "rawStamp took {0}ns {1} {2}", new Object[]{stop - start, state, rawStamp.remaining()});
            }
            long stop = System.nanoTime();
            LOG.log(Level.INFO, "rawStamp took {0}ns {1} {2}", new Object[]{stop - start, state, rawStamp.remaining()});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stampCallback(StateMetaData state, ByteBuffer stamp) {
            long start = System.nanoTime();
            try {
                this.listener.stamp(state, stamp);
            }
            catch (Exception x) {
                try {
                    LOG.log(Level.WARNING, "stamp callback failed", x);
                }
                catch (Throwable throwable) {
                    long stop = System.nanoTime();
                    LOG.log(Level.INFO, "stamp took {0}ns {1} {2}", new Object[]{stop - start, state, stamp.remaining()});
                    throw throwable;
                }
                long stop = System.nanoTime();
                LOG.log(Level.INFO, "stamp took {0}ns {1} {2}", new Object[]{stop - start, state, stamp.remaining()});
            }
            long stop = System.nanoTime();
            LOG.log(Level.INFO, "stamp took {0}ns {1} {2}", new Object[]{stop - start, state, stamp.remaining()});
        }

        public String getPartition() {
            return this.store.getPartition();
        }

        @Override
        public void close() throws DAQException {
            long sub = this.subscriber;
            if (sub != 0L) {
                this.subscriber = 0L;
                this.store.abortWaitForGuider(sub);
                try {
                    this.waitThread.join();
                }
                catch (InterruptedException ex) {
                    throw new DAQException("Unexpected interrupt");
                }
                this.store.detachGuiderSubscriber(sub);
            }
        }
    }
}

