/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.power.PowerDevice;
import org.lsst.ccs.subsystem.power.config.Power;
import org.lsst.ccs.subsystem.power.data.PowerChanState;
import org.lsst.ccs.subsystem.power.data.PowerException;

public class PowerControl
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(PowerControl.class.getName());
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    protected PowerDevice pDevc;
    @ConfigurationParameter(category="Power", isFinal=true, units="V", description="Voltage to set")
    private volatile double voltage;
    @ConfigurationParameter(category="Power", isFinal=true, units="A", description="Current limit to set")
    private volatile double current;
    @ConfigurationParameter(category="Power", isFinal=true, units="s", description="Power on delay (seconds)")
    private volatile double onDelay;
    @ConfigurationParameter(category="Power", isFinal=true, units="s", description="Power off delay (seconds)")
    private volatile double offDelay;
    private int hwChan;
    private String description;
    private double opVoltage;
    private double opCurrent;
    private double opOnDelay;
    private double opOffDelay;

    public void init() {
        if (this.hwChan < this.pDevc.getMinChannel() || this.hwChan > this.pDevc.getMaxChannel()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)("hw channel number (" + this.hwChan + ")"), (String)"is invalid");
        }
        this.opVoltage = this.voltage;
        this.opCurrent = this.current;
        this.opOnDelay = this.onDelay;
        this.opOffDelay = this.offDelay;
    }

    public void setVoltage(double value) {
        this.opVoltage = value;
    }

    public double getVoltage() {
        return this.opVoltage;
    }

    public void setCurrent(double value) {
        this.opCurrent = value;
    }

    public double getCurrent() {
        return this.opCurrent;
    }

    public void setOnDelay(double value) {
        this.opOnDelay = value;
    }

    public double getOnDelay() {
        return this.opOnDelay;
    }

    public void setOffDelay(double value) {
        this.opOffDelay = value;
    }

    public double getOffDelay() {
        return this.opOffDelay;
    }

    public void changeVoltage(double value) throws PowerException {
        this.pDevc.writeVoltage(value, this.hwChan);
    }

    void setConfig(Power.Channel chan) {
        this.opVoltage = chan.getVoltage();
        this.opCurrent = chan.getCurrent();
        this.opOnDelay = chan.getOnDelay();
        this.opOffDelay = chan.getOffDelay();
    }

    Power.Channel getConfig() {
        Power.Channel chan = new Power.Channel();
        chan.setName(this.name);
        chan.setVoltage(this.opVoltage);
        chan.setCurrent(this.opCurrent);
        chan.setOnDelay(this.opOnDelay);
        chan.setOffDelay(this.opOffDelay);
        return chan;
    }

    PowerChanState getState() {
        PowerChanState pwr = new PowerChanState();
        pwr.setName(this.name);
        try {
            pwr.setVoltage(this.readVoltage());
            pwr.setCurrent(this.readCurrent());
            Boolean outState = this.readOutput();
            pwr.setState(outState == null ? -1 : (outState != false ? 1 : 0));
        }
        catch (PowerException e) {
            pwr.setVoltage(0.0);
            pwr.setCurrent(0.0);
            pwr.setState(-1);
        }
        return pwr;
    }

    public void writeAll() throws PowerException {
        this.writeVoltage();
        this.writeCurrent();
        this.writeOnDelay();
        this.writeOffDelay();
    }

    public void writeVoltage() throws PowerException {
        this.pDevc.writeVoltage(this.opVoltage, this.hwChan);
    }

    public double readVoltage() throws PowerException {
        return this.pDevc.readVoltage(this.hwChan);
    }

    public void writeCurrent() throws PowerException {
        this.pDevc.writeCurrent(this.opCurrent, this.hwChan);
    }

    public double readCurrent() throws PowerException {
        return this.pDevc.readCurrent(this.hwChan);
    }

    public void writeOnDelay() throws PowerException {
        this.pDevc.writeOnDelay(this.opOnDelay, this.hwChan);
    }

    public void writeOffDelay() throws PowerException {
        this.pDevc.writeOffDelay(this.opOffDelay, this.hwChan);
    }

    public void writeOutput(boolean on) throws PowerException {
        this.pDevc.writeOutput(on, this.hwChan);
    }

    public Boolean readOutput() {
        return this.pDevc.readOutput(this.hwChan);
    }

    public PowerDevice getDevice() {
        return this.pDevc;
    }

    public int getHwChan() {
        return this.hwChan;
    }
}

