/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.influxdb.dto.Point;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.statusdb.LocalDBAlert;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.InfluxDbClientService;
import org.lsst.ccs.services.alert.AlertService;

public abstract class BatchPersister<T>
implements Runnable,
HasLifecycle {
    protected final Logger log = Logger.getLogger(this.getClass().getCanonicalName());
    @LookupName
    private String persisterName;
    protected final Queue<T> rq = new ConcurrentLinkedQueue<T>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    InfluxDbClientService influxDbClientService;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentPeriodicTaskService periodicTaskService;
    private volatile boolean drainQueue = false;
    protected int ingThreadsPoolSize = 1;
    protected int ingQueueSize = 1;
    @ConfigurationParameter(category="General", description="Maximum number of entities to ingest in a single database transaction.")
    private volatile int maxIngestionSize = 1000;
    private ExecutorService exec;
    private boolean slowProcessing = false;
    private volatile AlertState batchSubmissionAlertState = AlertState.NOMINAL;

    BatchPersister() {
        this(false);
    }

    BatchPersister(boolean slowProcessing) {
        this.slowProcessing = slowProcessing;
    }

    public static ExecutorService newFixedThreadPoolBoundedQueue(int nThreads, int nQueue) {
        LinkedBlockingQueue<Runnable> queue = nQueue > 0 ? new LinkedBlockingQueue<Runnable>(nQueue) : new LinkedBlockingQueue();
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, queue);
    }

    public void shutdown() {
        this.drainQueue = true;
        this.rq.clear();
        this.exec.shutdownNow();
    }

    public void build() {
        this.log.log(Level.INFO, "Building Executor for {0} with {1} threads and pool size of {2}", new Object[]{this.persisterName, this.ingThreadsPoolSize, this.ingQueueSize});
        this.exec = BatchPersister.newFixedThreadPoolBoundedQueue(this.ingThreadsPoolSize, this.ingQueueSize);
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask(this.name, (Runnable)this).withIsFixedRate(false).withPeriod(Duration.ofMillis(100L)));
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(LocalDBAlert.BatchException.getAlert(this.persisterName, null), alwaysClear);
        this.alertService.registerAlert(LocalDBAlert.BatchRollbackException.getAlert(this.persisterName, null), alwaysClear);
        this.alertService.registerAlert(LocalDBAlert.BatchIngestionQueueSize.getAlert(this.persisterName, null), alwaysClear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistBatch(List<T> batch) {
        this.log.log(Level.FINER, "{0} start batch {1} {2} {3}", new Object[]{this.persisterName, this.getClass().getName(), this, batch.size()});
        long tstart = System.currentTimeMillis();
        Session sess = StatusdbUtils.getSessionFactory().openSession();
        sess.setFlushMode(FlushMode.COMMIT);
        Transaction tx = null;
        try {
            tx = sess.beginTransaction();
            for (T t : batch) {
                this.persist(t, sess);
            }
            tx.commit();
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, this.persisterName + " caught exception when persisting", ex);
            this.alertService.raiseAlert(LocalDBAlert.BatchException.getAlert(this.persisterName, ex), AlertState.WARNING, LocalDBAlert.getFirstException(ex));
            try {
                if (tx != null && (tx.getStatus() == TransactionStatus.ACTIVE || tx.getStatus() == TransactionStatus.MARKED_ROLLBACK)) {
                    tx.rollback();
                }
            }
            catch (Exception rbEx) {
                this.log.log(Level.SEVERE, this.persisterName + " Rollback of transaction failed : " + rbEx, rbEx);
                this.alertService.raiseAlert(LocalDBAlert.BatchRollbackException.getAlert(this.persisterName, ex), AlertState.WARNING, LocalDBAlert.getFirstException(ex));
            }
        }
        finally {
            if (sess.isOpen()) {
                sess.close();
            }
        }
        long time = System.currentTimeMillis() - tstart;
        if (this.influxDbClientService.isEnabled()) {
            Point.Builder batchPersisterPointBuilder = Point.measurement((String)"db_persist").time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            batchPersisterPointBuilder = batchPersisterPointBuilder.addField("btime_tot", time).addField("bcount", batch.size()).addField("btime_avg", (double)time / (double)batch.size());
            Point point = batchPersisterPointBuilder.tag("persister", this.persisterName).tag(this.influxDbClientService.getGlobalTags()).build();
            this.influxDbClientService.write(point);
        }
        this.log.log(Level.FINER, "{0} end batch ", this.persisterName);
    }

    @Override
    public void run() {
        this.log.log(Level.FINE, "{0} start run {1}", new Object[]{this.persisterName, this.rq.size()});
        int n = 0;
        int nAcc = 0;
        boolean done = false;
        long tstart = System.currentTimeMillis();
        while (!done) {
            ArrayList<T> batch = new ArrayList<T>(this.maxIngestionSize);
            int i = 0;
            while (i < this.maxIngestionSize) {
                T t = this.rq.poll();
                n = i++;
                if (t == null) {
                    done = i == 0;
                    break;
                }
                batch.add(t);
            }
            if (batch.size() > 0) {
                try {
                    Future<?> f = this.exec.submit(() -> this.persistBatch(batch));
                    if (this.slowProcessing) {
                        f.get();
                    }
                    if (!this.slowProcessing) {
                        int taskSubmissionQueueSize = ((ThreadPoolExecutor)this.exec).getQueue().size();
                        Object cause = null;
                        if ((double)taskSubmissionQueueSize > (double)this.ingQueueSize * 0.7 && this.batchSubmissionAlertState == AlertState.NOMINAL) {
                            cause = "The submission queue is filling up. Ingestion is falling behind.\n";
                            this.batchSubmissionAlertState = AlertState.WARNING;
                        } else if ((double)taskSubmissionQueueSize < (double)this.ingQueueSize * 0.5 && this.batchSubmissionAlertState != AlertState.NOMINAL) {
                            cause = "The submission queue is being drained. Ingestion is catching up.\n";
                            this.batchSubmissionAlertState = AlertState.NOMINAL;
                        }
                        if (cause != null) {
                            Alert batchSubmissionAlert = LocalDBAlert.BatchIngestionQueueSize.getAlert(this.persisterName, null);
                            cause = (String)cause + "Executor task queue size: " + taskSubmissionQueueSize + " (nThreads=" + this.ingThreadsPoolSize + ")";
                            this.alertService.raiseAlert(batchSubmissionAlert, this.batchSubmissionAlertState, (String)cause);
                        }
                    }
                }
                catch (InterruptedException | ExecutionException | RejectedExecutionException e) {
                    if (this.batchSubmissionAlertState != AlertState.ALARM) {
                        String cause = "Failed to submit a new task. Ingestion is all filled up. \nExecutor task queue size " + ((ThreadPoolExecutor)this.exec).getQueue().size();
                        this.batchSubmissionAlertState = AlertState.ALARM;
                        Alert batchSubmissionAlert = LocalDBAlert.BatchIngestionQueueSize.getAlert(this.persisterName, null);
                        this.alertService.raiseAlert(batchSubmissionAlert, this.batchSubmissionAlertState, cause);
                    }
                    this.rq.addAll(batch);
                }
                boolean bl = done = this.rq.size() < this.maxIngestionSize / 5 || this.slowProcessing;
                if (done) {
                    this.log.log(Level.FINE, "{0} run done, left in queue {1}", new Object[]{this.persisterName, this.rq.size()});
                }
            }
            if (n <= 0) continue;
            nAcc += n;
            this.log.log(Level.FINER, "{0} processed {1} entities.", new Object[]{this.persisterName, n});
        }
        if (nAcc > 0) {
            long time = System.currentTimeMillis() - tstart;
            if (this.influxDbClientService.isEnabled()) {
                Point.Builder batchPersisterPointBuilder = Point.measurement((String)"db_persist").time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                int submissionQueueSize = ((ThreadPoolExecutor)this.exec).getQueue().size();
                double perThreadSize = (double)submissionQueueSize / (double)this.ingThreadsPoolSize;
                batchPersisterPointBuilder = batchPersisterPointBuilder.addField("time_tot", time).addField("count", nAcc).addField("time_avg", (double)time / (double)nAcc).addField("exec_queue_size", (double)submissionQueueSize).addField("exec_queue_size_per_threads", perThreadSize).addField("proc_queue_size", this.rq.size());
                Point point = batchPersisterPointBuilder.tag("persister", this.persisterName).tag(this.influxDbClientService.getGlobalTags()).build();
                this.influxDbClientService.write(point);
            }
        }
        this.log.log(Level.FINE, "{0} end run ", this.persisterName);
    }

    public void addToQueue(T obj) {
        if (!this.drainQueue) {
            this.rq.add(obj);
        }
    }

    public abstract void persist(T var1, Session var2);

    public Duration getBatchProcessingPeriod() {
        return this.periodicTaskService.getPeriodicTaskPeriod(this.name);
    }
}

