/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.efd;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.influxdb.dto.Query;
import org.lsst.ccs.camera.sal.xml.Mapping;

public class EfdQueryBuilder {
    private final Map<String, EfdPathWrapper> pathToWrapperMap = new ConcurrentHashMap<String, EfdPathWrapper>();
    private final String namespace;
    private final Mapping map = Mapping.getMapping((String)"avro.map");
    private EfdPathWrapper efdPathWrapper;
    private long startTime = -1L;
    private long endTime = -1L;
    private int nSamples = -1;

    public EfdQueryBuilder(String namespace) {
        this.namespace = namespace;
    }

    public EfdQueryBuilder forPath(String path) {
        this.efdPathWrapper = this.pathToWrapperMap.computeIfAbsent(path, p -> new EfdPathWrapper(path));
        return this;
    }

    public EfdPathWrapper getEfdPathWrapper() {
        return this.efdPathWrapper;
    }

    public EfdQueryBuilder withTimeRange(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        return this;
    }

    public EfdQueryBuilder withSamples(int nSamples) {
        this.nSamples = nSamples;
        return this;
    }

    public boolean isRawData() {
        return this.nSamples < 1;
    }

    public long getTimeWidth() {
        return (this.endTime - this.startTime) / (long)this.nSamples;
    }

    public Query buildQuery() {
        if (this.startTime == -1L || this.endTime == -1L) {
            throw new RuntimeException("Start and End times must be specified.");
        }
        boolean groupBy = this.nSamples > 0;
        Object queryStr = "select ";
        String field = this.efdPathWrapper.getField();
        queryStr = groupBy ? (String)queryStr + "max(" + field + ") as maxValue, min(" + field + ") as minValue, mean(" + field + ") as meanValue, stddev(" + field + ") as stddevValue" : (String)queryStr + field;
        queryStr = (String)queryStr + " from \"" + this.efdPathWrapper.getTopicName() + "\" where time >  " + this.startTime + "ms  and time < " + this.endTime + "ms ";
        for (String tag : this.efdPathWrapper.getTags()) {
            queryStr = (String)queryStr + "and " + tag + " = '" + this.efdPathWrapper.getTagValue(tag) + "' ";
        }
        if (groupBy) {
            queryStr = (String)queryStr + "group by time(" + this.getTimeWidth() + "ms) fill(none)";
        }
        return new Query((String)queryStr, this.efdPathWrapper.getNamespace());
    }

    public class EfdPathWrapper {
        private final Map<String, String> tags = new ConcurrentHashMap<String, String>();
        private final String topicName;
        private final String field;

        EfdPathWrapper(String path) {
            int firstSlash = path.indexOf("/");
            String agentName = path.substring(0, firstSlash);
            String pathWithoutAgent = path.substring(firstSlash + 1);
            Mapping.Match match = EfdQueryBuilder.this.map.match(pathWithoutAgent);
            if (match == null) {
                throw new RuntimeException("Could not find a match for path " + pathWithoutAgent);
            }
            this.topicName = EfdQueryBuilder.this.namespace + "." + match.getPatternName();
            for (String tag : match.getTagNames()) {
                this.tags.put(tag, match.getTagValue(tag));
            }
            this.tags.put("Agent", agentName);
            this.field = match.getPathAfterMatch();
        }

        public String getNamespace() {
            return EfdQueryBuilder.this.namespace;
        }

        public String getTopicName() {
            return this.topicName;
        }

        public String getField() {
            return this.field;
        }

        public Set<String> getTags() {
            return this.tags.keySet();
        }

        public String getTagValue(String tag) {
            return this.tags.get(tag);
        }
    }
}

