/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.web.Callback;

class WebCallableClient
implements CallableClient {
    private final List queue_;
    private final int capacity_;
    private boolean ended_;
    public static final int DEFAULT_CAPACITY = 4096;

    public WebCallableClient() {
        this(4096);
    }

    public WebCallableClient(int capacity) {
        this.capacity_ = capacity;
        this.queue_ = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List pullCallbacks(int timeout) throws SampException {
        long end = timeout >= 0 ? System.currentTimeMillis() + (long)(timeout * 1000) : Long.MAX_VALUE;
        try {
            List list = this.queue_;
            synchronized (list) {
                while (this.queue_.isEmpty() && end - System.currentTimeMillis() > 0L && !this.ended_) {
                    this.queue_.wait(end - System.currentTimeMillis());
                }
                ArrayList callbacks = new ArrayList(this.queue_);
                this.queue_.clear();
                return callbacks;
            }
        }
        catch (InterruptedException e) {
            throw new SampException("Interrupted", e);
        }
    }

    public void receiveNotification(String senderId, Message message) {
        this.enqueue("receiveNotification", new Object[]{senderId, message});
    }

    public void receiveCall(String senderId, String msgId, Message message) {
        this.enqueue("receiveCall", new Object[]{senderId, msgId, message});
    }

    public void receiveResponse(String responderId, String msgTag, Response response) {
        this.enqueue("receiveResponse", new Object[]{responderId, msgTag, response});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCallbacks() {
        this.ended_ = true;
        List list = this.queue_;
        synchronized (list) {
            this.queue_.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(String methodName, Object[] params) {
        Callback callback = new Callback("" + methodName, Arrays.asList(params));
        callback.check();
        List list = this.queue_;
        synchronized (list) {
            if (this.queue_.size() >= this.capacity_) {
                throw new IllegalStateException("Callback queue is full (" + this.capacity_ + " objects)");
            }
            this.queue_.add(callback);
            this.queue_.notifyAll();
        }
    }
}

