/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.DATAREADER_QOS_DEFAULT;
import DDS.DATAREADER_QOS_USE_TOPIC_QOS;
import DDS.DataReader;
import DDS.DataReaderListener;
import DDS.DataReaderQos;
import DDS.DataReaderQosHolder;
import DDS.DataReaderSeqHolder;
import DDS.DomainParticipant;
import DDS.EntityOperations;
import DDS.LivelinessChangedStatus;
import DDS.RequestedDeadlineMissedStatus;
import DDS.RequestedIncompatibleQosStatus;
import DDS.SUBSCRIBER_QOS_DEFAULT;
import DDS.SampleLostStatus;
import DDS.SampleRejectedStatus;
import DDS.Subscriber;
import DDS.SubscriberListener;
import DDS.SubscriberQos;
import DDS.SubscriberQosHolder;
import DDS.SubscriptionMatchedStatus;
import DDS.TOPIC_QOS_DEFAULT;
import DDS.TopicQos;
import DDS.TopicQosHolder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opensplice.dds.dcps.ContentFilteredTopicImpl;
import org.opensplice.dds.dcps.DataReaderImpl;
import org.opensplice.dds.dcps.DomainParticipantImpl;
import org.opensplice.dds.dcps.Event;
import org.opensplice.dds.dcps.ListenerDispatcher;
import org.opensplice.dds.dcps.MultiTopicImpl;
import org.opensplice.dds.dcps.ReportStack;
import org.opensplice.dds.dcps.SubscriberBase;
import org.opensplice.dds.dcps.TopicDescription;
import org.opensplice.dds.dcps.TopicImpl;
import org.opensplice.dds.dcps.Utilities;

public class SubscriberImpl
extends SubscriberBase
implements Subscriber {
    private static final long serialVersionUID = 4597853351956995366L;
    private DataReaderQos defaultDataReaderQos = Utilities.defaultDataReaderQos;
    private DomainParticipantImpl participant = null;
    private final Set<DataReaderImpl> readers = Collections.synchronizedSet(new HashSet());
    private String name;
    private SubscriberListener listener = null;
    private boolean factoryAutoEnable = false;

    protected SubscriberImpl() {
    }

    protected int init(DomainParticipantImpl participant, String name, SubscriberQos qos) {
        int result = 0;
        long uParticipant = participant.get_user_object();
        if (uParticipant != 0L) {
            long uSubscriber = this.jniSubscriberNew(uParticipant, name, qos);
            if (uSubscriber != 0L) {
                this.set_user_object(uSubscriber);
                this.name = name;
                this.factoryAutoEnable = qos.entity_factory.autoenable_created_entities;
                this.participant = participant;
                this.setDomainId(participant.getDomainId());
            }
        } else {
            result = 9;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int deinit() {
        int result = 0;
        SubscriberImpl subscriberImpl = this;
        synchronized (subscriberImpl) {
            long uSubscriber = this.get_user_object();
            if (uSubscriber != 0L) {
                if (this.readers.size() == 0) {
                    if (this.listener != null) {
                        result = this.set_listener(this.listener, 0);
                    }
                    if (result == 0 && (result = this.disable_callbacks()) == 0 && (result = this.detach_statuscondition()) == 0) {
                        this.participant = null;
                        this.name = null;
                        result = this.jniSubscriberFree(uSubscriber);
                        if (result == 0) {
                            result = super.deinit();
                        }
                    }
                } else {
                    result = 4;
                    ReportStack.report(result, "Subscriber still contains '" + this.readers.size() + "' DataReader entities.");
                }
            } else {
                result = 9;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataReader create_datareader(DDS.TopicDescription description, DataReaderQos qos, DataReaderListener a_listener, int mask) {
        DataReaderImpl reader = null;
        int result = 0;
        ReportStack.start();
        if (description == null || qos == null) {
            result = 3;
            ReportStack.report(result, "Description or Qos is null");
        } else if (qos == DATAREADER_QOS_DEFAULT.value) {
            qos = this.defaultDataReaderQos;
        } else if (qos == DATAREADER_QOS_USE_TOPIC_QOS.value) {
            DataReaderQosHolder holder = new DataReaderQosHolder();
            this.copy_from_topicdescription_qos(holder, description);
            qos = holder.value;
            result = Utilities.checkQos(qos);
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            SubscriberImpl subscriberImpl = this;
            synchronized (subscriberImpl) {
                long uSubscriber = this.get_user_object();
                if (uSubscriber != 0L) {
                    if (this.participant.equals(description.get_participant())) {
                        String name = "reader <" + description.get_name() + ">";
                        reader = (DataReaderImpl)((TopicDescription)((Object)description)).create_datareader();
                        if (reader != null) {
                            result = reader.init(this, name, description, qos);
                            if (result == 0) {
                                this.readers.add(reader);
                                ListenerDispatcher dispatcher = this.get_dispatcher();
                                result = reader.set_dispatcher(dispatcher);
                            } else {
                                reader = null;
                                ReportStack.report(result, "DataReader could not be initialized.");
                            }
                            if (result == 0) {
                                result = reader.set_listener(a_listener, mask);
                            }
                            if (result == 0 && this.factoryAutoEnable && this.is_enabled() && (result = reader.enable()) != 0) {
                                ReportStack.report(result, "DataReader could not be enabled.");
                            }
                            if (result != 0 && reader != null) {
                                this.delete_datareader(reader);
                                reader = null;
                            }
                        } else {
                            result = 1;
                            ReportStack.report(result, "DataReader could not be created.");
                        }
                    } else {
                        result = 4;
                        ReportStack.report(result, "Topic does not belong to the same DomainParticipant as this Subscriber.");
                    }
                } else {
                    result = 9;
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_datareader(DataReader reader) {
        int result = 0;
        ReportStack.start();
        if (reader == null) {
            result = 3;
            ReportStack.report(result, "a_datareader 'null' is invalid.");
        } else {
            DataReaderImpl dr = (DataReaderImpl)reader;
            boolean removed = false;
            SubscriberImpl subscriberImpl = this;
            synchronized (subscriberImpl) {
                removed = this.readers.remove(dr);
                if (removed) {
                    result = dr.deinit();
                    if (result == 4) {
                        this.readers.add(dr);
                    }
                } else if (dr.get_user_object() == 0L) {
                    result = 9;
                } else {
                    result = 4;
                    ReportStack.report(result, "DataReader not created by Subscriber.");
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains_entity(long a_handle) {
        boolean found = false;
        ReportStack.start();
        Set<DataReaderImpl> set = this.readers;
        synchronized (set) {
            Iterator<DataReaderImpl> it = this.readers.iterator();
            while (it.hasNext() && !found) {
                long handle = it.next().get_instance_handle();
                found = handle == a_handle;
            }
        }
        ReportStack.flush(this, !found);
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_contained_entities() {
        int endResult = 0;
        ReportStack.start();
        HashSet<DataReaderImpl> survivors = new HashSet<DataReaderImpl>();
        DataReaderImpl dr = null;
        do {
            dr = null;
            Set<DataReaderImpl> set = this.readers;
            synchronized (set) {
                Iterator<DataReaderImpl> dri = this.readers.iterator();
                while (dri.hasNext()) {
                    dr = dri.next();
                    dri.remove();
                    if (!survivors.contains(dr)) break;
                    dr = null;
                }
            }
            if (dr == null) continue;
            int result = dr.delete_contained_entities();
            if (result == 0) {
                result = dr.deinit();
                if (result != 0 && result != 9) {
                    survivors.add(dr);
                    set = this.readers;
                    synchronized (set) {
                        this.readers.add(dr);
                    }
                }
                if (result != 0) {
                    ReportStack.report(result, "Deletion of DataReader contained in Subscriber failed.");
                }
            } else {
                ReportStack.report(result, "delete_contained_entities failed on DataReader contained in Subscriber.");
                if (result != 9) {
                    survivors.add(dr);
                    set = this.readers;
                    synchronized (set) {
                        this.readers.add(dr);
                    }
                }
            }
            if (endResult != 0) continue;
            endResult = result;
        } while (dr != null);
        ReportStack.flush(this, endResult != 0);
        return endResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataReader lookup_datareader(String topic_name) {
        DataReaderImpl found = null;
        Set<DataReaderImpl> set = this.readers;
        synchronized (set) {
            for (DataReaderImpl reader : this.readers) {
                if (!reader.get_topicdescription().get_name().equals(topic_name)) continue;
                found = reader;
                break;
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int get_datareaders(DataReaderSeqHolder readers, int sample_states, int view_states, int instance_states) {
        int result = 0;
        ReportStack.start();
        if (readers == null) {
            result = 3;
            ReportStack.report(result, "readers 'null' is invalid.");
        } else {
            SubscriberImpl subscriberImpl = this;
            synchronized (subscriberImpl) {
                long uSubscriber = this.get_user_object();
                result = uSubscriber != 0L ? this.jniGetDataReaders(uSubscriber, readers, sample_states, view_states, instance_states) : 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int notify_datareaders() {
        int result = 0;
        ReportStack.start();
        if (this.get_user_object() != 0L) {
            HashSet<EntityOperations> processed = new HashSet<EntityOperations>();
            EntityOperations reader = null;
            do {
                DataReaderListener readerListener;
                reader = null;
                Set<DataReaderImpl> set = this.readers;
                synchronized (set) {
                    for (DataReaderImpl r : this.readers) {
                        if (processed.contains(r)) continue;
                        reader = r;
                        break;
                    }
                }
                if (reader == null) continue;
                if ((reader.get_status_changes() & 0x400) != 0 && (readerListener = reader.get_listener()) != null) {
                    readerListener.on_data_available((DataReader)reader);
                }
                processed.add(reader);
            } while (reader != null);
        } else {
            result = 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int set_qos(SubscriberQos qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos == SUBSCRIBER_QOS_DEFAULT.value) {
            SubscriberQosHolder holder = new SubscriberQosHolder();
            this.participant.get_default_subscriber_qos(holder);
            qos = holder.value;
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            long uSubscriber = this.get_user_object();
            if (uSubscriber != 0L) {
                result = this.jniSetQos(uSubscriber, qos);
                if (result == 0) {
                    this.factoryAutoEnable = qos.entity_factory.autoenable_created_entities;
                }
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_qos(SubscriberQosHolder qosHolder) {
        int result = 0;
        ReportStack.start();
        if (qosHolder == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else {
            long uSubscriber = this.get_user_object();
            result = uSubscriber != 0L ? this.jniGetQos(uSubscriber, qosHolder) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int set_listener(SubscriberListener a_listener, int mask) {
        int result = 0;
        ReportStack.start();
        SubscriberImpl subscriberImpl = this;
        synchronized (subscriberImpl) {
            if (this.get_user_object() != 0L) {
                this.listener = a_listener;
                result = this.set_listener_interest(mask);
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public SubscriberListener get_listener() {
        return this.listener;
    }

    @Override
    public int begin_access() {
        long uSubscriber = 0L;
        int result = 0;
        ReportStack.start();
        uSubscriber = this.get_user_object();
        result = uSubscriber != 0L ? this.jniBeginAccess(uSubscriber) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int end_access() {
        long uSubscriber = 0L;
        int result = 0;
        ReportStack.start();
        uSubscriber = this.get_user_object();
        result = uSubscriber != 0L ? this.jniEndAccess(uSubscriber) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public DomainParticipant get_participant() {
        DomainParticipantImpl participant = null;
        int result = 0;
        ReportStack.start();
        if (this.get_user_object() != 0L) {
            participant = this.participant;
        } else {
            result = 9;
        }
        ReportStack.flush(this, result != 0);
        return participant;
    }

    @Override
    public int set_default_datareader_qos(DataReaderQos qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos == DATAREADER_QOS_USE_TOPIC_QOS.value) {
            result = 3;
            ReportStack.report(result, "qos 'DATAREADER_QOS_USE_TOPIC_QOS' is invalid in this context.");
        } else if (qos == DATAREADER_QOS_DEFAULT.value) {
            qos = Utilities.defaultDataReaderQos;
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            if (this.get_user_object() != 0L) {
                this.defaultDataReaderQos = Utilities.deepCopy(qos);
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_default_datareader_qos(DataReaderQosHolder qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (this.get_user_object() == 0L) {
            result = 9;
        } else {
            qos.value = Utilities.deepCopy(this.defaultDataReaderQos);
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int copy_from_topic_qos(DataReaderQosHolder qosHolder, TopicQos topic_qos) {
        int result = 0;
        ReportStack.start();
        if (qosHolder == null) {
            result = 3;
            ReportStack.report(result, "a_datareader_qos 'null' is invalid.");
        } else if (topic_qos == null) {
            result = 3;
            ReportStack.report(result, "a_topic_qos 'null' is invalid.");
        } else if (topic_qos == TOPIC_QOS_DEFAULT.value) {
            TopicQosHolder holder = new TopicQosHolder();
            this.participant.get_default_topic_qos(holder);
            topic_qos = holder.value;
        } else {
            result = Utilities.checkQos(topic_qos);
        }
        if (result == 0) {
            DataReaderQos qos = qosHolder.value;
            if (qos == null) {
                qos = Utilities.deepCopy(this.defaultDataReaderQos);
            }
            qos.durability = Utilities.deepCopy(topic_qos.durability);
            qos.deadline = Utilities.deepCopy(topic_qos.deadline);
            qos.latency_budget = Utilities.deepCopy(topic_qos.latency_budget);
            qos.liveliness = Utilities.deepCopy(topic_qos.liveliness);
            qos.reliability = Utilities.deepCopy(topic_qos.reliability);
            qos.destination_order = Utilities.deepCopy(topic_qos.destination_order);
            qos.history = Utilities.deepCopy(topic_qos.history);
            qos.resource_limits = Utilities.deepCopy(topic_qos.resource_limits);
            qos.ownership = Utilities.deepCopy(topic_qos.ownership);
            qosHolder.value = qos;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    protected int copy_from_topicdescription_qos(DataReaderQosHolder qosHolder, DDS.TopicDescription description) {
        TopicQosHolder holder;
        int result = 0;
        TopicImpl topic = null;
        if (description instanceof TopicImpl) {
            topic = (TopicImpl)description;
        } else if (description instanceof ContentFilteredTopicImpl) {
            topic = (TopicImpl)((ContentFilteredTopicImpl)description).get_related_topic();
        } else {
            result = description instanceof MultiTopicImpl ? 2 : 3;
        }
        if (result == 0 && (result = topic.get_qos(holder = new TopicQosHolder())) == 0) {
            result = this.copy_from_topic_qos(qosHolder, holder.value);
        }
        return result;
    }

    @Override
    protected int notify(Event e) {
        int result = 0;
        SubscriberListener sl = this.listener;
        if (sl == null) {
            return result;
        }
        switch (e.kind) {
            case 512: {
                sl.on_data_on_readers((Subscriber)((Object)e.observer));
                break;
            }
            case 1024: {
                sl.on_data_available((DataReader)((Object)e.observable));
                break;
            }
            case 4: {
                sl.on_requested_deadline_missed((DataReader)((Object)e.observable), (RequestedDeadlineMissedStatus)e.status);
                break;
            }
            case 64: {
                sl.on_requested_incompatible_qos((DataReader)((Object)e.observable), (RequestedIncompatibleQosStatus)e.status);
                break;
            }
            case 256: {
                sl.on_sample_rejected((DataReader)((Object)e.observable), (SampleRejectedStatus)e.status);
                break;
            }
            case 4096: {
                sl.on_liveliness_changed((DataReader)((Object)e.observable), (LivelinessChangedStatus)e.status);
                break;
            }
            case 16384: {
                sl.on_subscription_matched((DataReader)((Object)e.observable), (SubscriptionMatchedStatus)e.status);
                break;
            }
            case 128: {
                sl.on_sample_lost((DataReader)((Object)e.observable), (SampleLostStatus)e.status);
                break;
            }
            default: {
                ReportStack.report(2, "Received unsupported event kind '" + e.kind + "'.");
            }
        }
        return result;
    }

    private native long jniSubscriberNew(long var1, String var3, SubscriberQos var4);

    private native int jniSubscriberFree(long var1);

    private native int jniSetQos(long var1, SubscriberQos var3);

    private native int jniGetQos(long var1, SubscriberQosHolder var3);

    private native int jniBeginAccess(long var1);

    private native int jniEndAccess(long var1);

    private native int jniGetDataReaders(long var1, DataReaderSeqHolder var3, int var4, int var5, int var6);
}

